/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.io;

import java.io.StringWriter;

public class CdStringWriter
extends StringWriter {
    private final int maxSize;
    private boolean maxSizeExceeded;

    public CdStringWriter(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void write(int c) {
        if (!this.maxSizeExceeded) {
            super.write(c);
            this.setupMaxSizeExceeded();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (!this.maxSizeExceeded) {
            super.write(cbuf, off, len);
            this.setupMaxSizeExceeded();
        }
    }

    @Override
    public void write(String str) {
        if (!this.maxSizeExceeded) {
            super.write(str);
            this.setupMaxSizeExceeded();
        }
    }

    @Override
    public void write(String str, int off, int len) {
        if (!this.maxSizeExceeded) {
            super.write(str, off, len);
            this.setupMaxSizeExceeded();
        }
    }

    public boolean isMaxSizeExceeded() {
        return this.maxSizeExceeded;
    }

    private void setupMaxSizeExceeded() {
        this.maxSizeExceeded = this.getBuffer().length() > this.maxSize;
    }
}

