/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.fs.revision;

import crazydev.common.fs.revision.CdVFileRevActionBookmark;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.utils.CdStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public abstract class CdVFileRevAction {
    @Nullable
    protected final String messageBy;
    protected final String message;

    public CdVFileRevAction(@Nullable String messageBy, String message) {
        this.messageBy = messageBy;
        this.message = message;
    }

    public boolean isBookmark() {
        return false;
    }

    public boolean isOperation() {
        return false;
    }

    public abstract void setupProperties(Properties var1);

    @Nullable
    public static List<CdVFileRevAction> create(Properties properties) {
        String bookmark;
        ArrayList<CdVFileRevAction> actions = null;
        String operation = properties.getProperty("operation");
        if (CdStringUtils.isNotNullAndNotBlank(operation)) {
            if (actions == null) {
                actions = new ArrayList<CdVFileRevAction>();
            }
            String operationBy = properties.getProperty("operationBy");
            actions.add(new CdVFileRevActionOperation(operationBy, operation));
        }
        if (CdStringUtils.isNotNullAndNotBlank(bookmark = properties.getProperty("bookmark"))) {
            if (actions == null) {
                actions = new ArrayList();
            }
            if (CdStringUtils.isNotNullAndNotBlank(operation)) {
                actions.add(new CdVFileRevActionBookmark(null, bookmark));
            } else {
                String operationBy = properties.getProperty("operationBy");
                actions.add(new CdVFileRevActionBookmark(operationBy, bookmark));
            }
        }
        return actions;
    }

    public String toString() {
        return this.message;
    }
}

