/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.PathUtils;

public abstract class CdVFileSystemUtils {
    private CdVFileSystemUtils() {
    }

    public static void copyDirectory(File src, File dest) throws IOException {
        FileUtils.copyDirectory((File)src, (File)dest, null, (boolean)true);
    }

    public static void deleteDirectory(File directory) throws IOException {
        Objects.requireNonNull(directory, "directory");
        if (!directory.exists()) {
            return;
        }
        if (!CdVFileSystemUtils.isSymlink(directory)) {
            CdVFileSystemUtils.cleanDirectory(directory);
        }
        CdVFileSystemUtils.delete(directory);
    }

    public static void cleanDirectory(File directory) throws IOException {
        File[] files = CdVFileSystemUtils.listFiles(directory, null);
        ArrayList<IOException> causeList = new ArrayList<IOException>();
        for (File file : files) {
            try {
                CdVFileSystemUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                causeList.add(ioe);
            }
        }
        if (!causeList.isEmpty()) {
            throw new IOExceptionList(directory.toString(), causeList);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                CdVFileSystemUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean isSymlink(File file) {
        return file != null && Files.isSymbolicLink(file.toPath());
    }

    private static File delete(File file) throws IOException {
        Objects.requireNonNull(file, "file");
        Files.delete(file.toPath());
        return file;
    }

    private static File[] listFiles(File directory, FileFilter fileFilter) throws IOException {
        File[] files;
        CdVFileSystemUtils.requireDirectoryExists(directory, "directory");
        File[] fileArray = files = fileFilter == null ? directory.listFiles() : directory.listFiles(fileFilter);
        if (files == null) {
            throw new IOException("Unknown I/O error listing contents of directory: " + String.valueOf(directory));
        }
        return files;
    }

    private static File requireDirectoryExists(File directory, String name) {
        CdVFileSystemUtils.requireExists(directory, name);
        CdVFileSystemUtils.requireDirectory(directory, name);
        return directory;
    }

    private static File requireExists(File file, String fileParamName) {
        Objects.requireNonNull(file, fileParamName);
        if (!file.exists()) {
            throw new IllegalArgumentException("File system element for parameter '" + fileParamName + "' does not exist: '" + String.valueOf(file) + "'");
        }
        return file;
    }

    private static File requireDirectory(File directory, String name) {
        Objects.requireNonNull(directory, name);
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Parameter '" + name + "' is not a directory: '" + String.valueOf(directory) + "'");
        }
        return directory;
    }

    private static void forceDelete(File file) throws IOException {
        Counters.PathCounters deleteCounters;
        Objects.requireNonNull(file, "file");
        try {
            deleteCounters = PathUtils.delete((Path)file.toPath(), (LinkOption[])PathUtils.EMPTY_LINK_OPTION_ARRAY, (DeleteOption[])new DeleteOption[0]);
        }
        catch (IOException e) {
            throw new IOException("Cannot delete file: " + String.valueOf(file), e);
        }
        if (deleteCounters.getFileCounter().get() < 1L && deleteCounters.getDirectoryCounter().get() < 1L) {
            throw new FileNotFoundException("File does not exist: " + String.valueOf(file));
        }
    }
}

