/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;

public interface ICdException
extends Serializable {
    public Throwable asThrowable();

    public CdErrorCode getErrorCode();

    public CdError getError();

    public boolean isCausedBy(CdErrorCode var1);

    public Throwable getCause();

    public String getMessage();

    public void printStackTrace();

    public void printStackTrace(PrintStream var1);

    public void printStackTrace(PrintWriter var1);

    public void updateLocationRange(int var1, int var2);

    public static class Impl {
        public static boolean isCausedBy(ICdException exception, CdErrorCode errorCode) {
            if (exception.getErrorCode() == errorCode) {
                return true;
            }
            Throwable causedBy = exception.getCause();
            if (causedBy instanceof ICdException) {
                ICdException causedByX = (ICdException)((Object)causedBy);
                return causedByX.isCausedBy(errorCode);
            }
            return false;
        }
    }
}

