/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.exception.CdCommonError;
import crazydev.common.exception.CdCommonErrorCode;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.exception.ICdException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class CdRuntimeException
extends RuntimeException
implements ICdException {
    private static final long serialVersionUID = 5941061208172795040L;
    private final CdError error;

    public CdRuntimeException(String message) {
        this(null, new CdCommonError(CdCommonErrorCode.GENERAL_ERROR, new Serializable[]{message}));
    }

    public CdRuntimeException(@Nullable Throwable cause, String message) {
        this(cause, new CdCommonError(CdCommonErrorCode.GENERAL_ERROR, new Serializable[]{message}));
    }

    public CdRuntimeException(CdError error) {
        this(null, error);
    }

    public CdRuntimeException(@Nullable Throwable cause, CdError error) {
        super(error.asMessage(CdLoggingBabylonService.INSTANCE), cause);
        this.error = error;
    }

    @Override
    public Throwable asThrowable() {
        return this;
    }

    @Override
    public String getMessage() {
        return this.error.asMessage(CdLoggingBabylonService.INSTANCE);
    }

    @Override
    public CdError getError() {
        return this.error;
    }

    @Override
    public CdErrorCode getErrorCode() {
        return this.error.getCode();
    }

    @Nullable
    public CdErrorLocation getLocation() {
        return this.error.getLocation();
    }

    @Override
    public void updateLocationRange(int from, int to) {
        CdErrorLocation location = this.getLocation();
        if (location != null) {
            location.updateLocationRange(from, to);
        }
    }

    @Override
    public boolean isCausedBy(CdErrorCode errorCode) {
        return ICdException.Impl.isCausedBy(this, errorCode);
    }

    @Override
    public String toString() {
        return this.error.asFullMessage(CdLoggingBabylonService.INSTANCE);
    }
}

