/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import java.util.Objects;
import org.apache.log4j.Logger;

public class CdFatalErrorHandler {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.general");
    private volatile boolean fatalErrorExit;

    public CdFatalErrorHandler() {
        this.fatalErrorExit = true;
    }

    public CdFatalErrorHandler(boolean exit) {
        this.fatalErrorExit = exit;
    }

    public void fatalErrorExit(boolean exit) {
        if (!exit) {
            LOGGER.info((Object)"[fatal-error] fatal error will not exit");
        }
        this.fatalErrorExit = exit;
    }

    public boolean isFatalErrorExit() {
        return this.fatalErrorExit;
    }

    public void handle(Throwable error, int exitCode) {
        LOGGER.fatal((Object)("[fatal-error] icCube got a fatal error - will exit(" + exitCode + ")"), error);
        this.bye(exitCode);
    }

    public void handle(String error, int exitCode) {
        LOGGER.fatal((Object)("[fatal-error] icCube got a fatal error - will exit(" + exitCode + ") : " + error));
        this.bye(exitCode);
    }

    private void bye(final int exitCode) {
        if (!this.fatalErrorExit) {
            LOGGER.fatal((Object)("[fatal-error] bye(" + exitCode + ") ignored due to fatalErrorExit = false"));
            return;
        }
        new Thread(new Runnable(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                LOGGER.fatal((Object)("[fatal-error] bye(" + exitCode + ")"));
                System.exit(exitCode);
            }
        }).start();
    }
}

