/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.exception.CdCommonError;
import crazydev.common.exception.CdCommonErrorCode;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.exception.ICdException;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class CdException
extends Exception
implements ICdException {
    private static final long serialVersionUID = -1918371799292926092L;
    private final CdError error;

    public CdException(String message) {
        this(null, new CdCommonError(CdCommonErrorCode.GENERAL_ERROR, new Serializable[]{message}));
    }

    public CdException(@Nullable Throwable cause, String message) {
        this(cause, new CdCommonError(CdCommonErrorCode.GENERAL_ERROR, new Serializable[]{message}));
    }

    protected CdException(CdError error) {
        this(null, error);
    }

    protected CdException(@Nullable Throwable cause, CdError error) {
        super(error.asMessage(CdLoggingBabylonService.INSTANCE), cause);
        this.error = error;
    }

    @Override
    public Throwable asThrowable() {
        return this;
    }

    @Override
    public CdError getError() {
        return this.error;
    }

    @Override
    public CdErrorCode getErrorCode() {
        return this.error.getCode();
    }

    @Nullable
    public CdErrorLocation getLocation() {
        return this.error.getLocation();
    }

    @Override
    public void updateLocationRange(int from, int to) {
        CdErrorLocation location = this.getLocation();
        if (location != null) {
            location.updateLocationRange(from, to);
        }
    }

    @Override
    public boolean isCausedBy(CdErrorCode errorCode) {
        return ICdException.Impl.isCausedBy(this, errorCode);
    }

    @Override
    public String toString() {
        return this.error.asFullMessage(CdLoggingBabylonService.INSTANCE);
    }
}

