/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import org.jetbrains.annotations.Nullable;

public class CdEmbeddedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 5941061208172795040L;
    private final CdError error;
    private final CdError embeddedError;

    public CdEmbeddedRuntimeException(CdError error, CdError embeddedError) {
        this.error = error;
        this.embeddedError = embeddedError;
    }

    public CdError getError() {
        return this.error;
    }

    public CdErrorCode getCode() {
        return this.error.getCode();
    }

    @Nullable
    public CdErrorLocation getLocation() {
        return this.error.getLocation();
    }

    public boolean isCausedBy(CdErrorCode errorCode) {
        return this.isCausedBy(errorCode.getValue());
    }

    public boolean isCausedBy(String errorCode) {
        for (Throwable causedBy = this; causedBy != null && causedBy instanceof CdEmbeddedRuntimeException; causedBy = causedBy.getCause()) {
            CdEmbeddedRuntimeException causedByX = causedBy;
            if (!causedByX.getCode().getValue().equals(errorCode)) continue;
            return true;
        }
        return false;
    }
}

