/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.credentials;

import crazydev.common.utils.CdStringUtils;
import org.jetbrains.annotations.Nullable;

public class CdCredentials {
    public final String userName;
    @Nullable
    public final String userRole;
    @Nullable
    public final String userPassword;

    private CdCredentials(String userName, @Nullable String userRole, @Nullable String userPassword) {
        this.userName = userName;
        this.userRole = userRole;
        this.userPassword = userPassword;
    }

    public static CdCredentials extractCredentials(@Nullable String userInformation, @Nullable String userPassword) {
        String userName = CdCredentials.extractUserName(userInformation);
        String userRole = CdCredentials.extractUserRole(userInformation);
        return new CdCredentials(userName, userRole, userPassword);
    }

    private static String extractUserName(@Nullable String credentials) {
        if (credentials == null) {
            return "";
        }
        int pos = credentials.indexOf("/");
        if (pos == -1) {
            return credentials;
        }
        return credentials.substring(0, pos);
    }

    @Nullable
    private static String extractUserRole(@Nullable String credentials) {
        if (credentials == null) {
            return null;
        }
        int pos = credentials.indexOf("/");
        if (pos == -1) {
            return null;
        }
        String role = credentials.substring(pos + 1);
        return CdStringUtils.isNullOrBlank(role) ? null : role;
    }

    public String toString() {
        return this.userName + (String)(this.userRole != null ? "/" + this.userRole : "");
    }
}

