/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.concurrent.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

public class CdAtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = -4313569665223679390L;
    protected static final long ZERO = CdAtomicDoubleArray.toLong(0.0);
    protected final AtomicLongArray bits;

    public CdAtomicDoubleArray(int length) {
        this.bits = new AtomicLongArray(length);
        for (int idx = 0; idx < length; ++idx) {
            this.bits.set(idx, ZERO);
        }
    }

    private CdAtomicDoubleArray(AtomicLongArray bits) {
        int length = bits.length();
        this.bits = new AtomicLongArray(length);
        for (int idx = 0; idx < length; ++idx) {
            this.bits.set(idx, bits.get(idx));
        }
    }

    public CdAtomicDoubleArray duplicate() {
        return new CdAtomicDoubleArray(this.bits);
    }

    public CdAtomicDoubleArray opposite() {
        CdAtomicDoubleArray clone = new CdAtomicDoubleArray(this.bits.length());
        int len = this.bits.length();
        for (int idx = 0; idx < len; ++idx) {
            long bit = this.bits.get(idx);
            if (bit == ZERO) continue;
            clone.set(idx, -CdAtomicDoubleArray.toDouble(bit));
        }
        return clone;
    }

    public static long toLong(double v) {
        return Double.doubleToLongBits(v);
    }

    public static double toDouble(long v) {
        return Double.longBitsToDouble(v);
    }

    public final int length() {
        return this.bits.length();
    }

    public final double get(int idx) {
        return CdAtomicDoubleArray.toDouble(this.bits.get(idx));
    }

    public final void set(int i, double newValue) {
        this.bits.set(i, CdAtomicDoubleArray.toLong(newValue));
    }

    public final double getAndSet(int i, double newValue) {
        return CdAtomicDoubleArray.toDouble(this.bits.getAndSet(i, CdAtomicDoubleArray.toLong(newValue)));
    }

    public boolean compareAndSet(int i, double expect, double update) {
        return this.bits.compareAndSet(i, CdAtomicDoubleArray.toLong(expect), CdAtomicDoubleArray.toLong(update));
    }

    public boolean compareAndSetLongDouble(int i, long expect, double update) {
        return this.bits.compareAndSet(i, expect, CdAtomicDoubleArray.toLong(update));
    }

    public final double getAndAdd(int i, double delta) {
        double currentAsDouble;
        double next;
        long currentAsLong;
        while (!this.compareAndSetLongDouble(i, currentAsLong = this.bits.get(i), next = (currentAsDouble = CdAtomicDoubleArray.toDouble(currentAsLong)) + delta)) {
        }
        return currentAsDouble;
    }

    public void add(int idx, double delta) {
        double currentAsDouble;
        long currentAsLong;
        while (!this.compareAndSetLongDouble(idx, currentAsLong = this.bits.get(idx), (currentAsDouble = CdAtomicDoubleArray.toDouble(currentAsLong)) + delta)) {
        }
    }

    public void addWithNaNasNull(int idx, double delta) {
        double currentAsDouble;
        long currentAsLong;
        if (Double.isNaN(delta)) {
            return;
        }
        while (!this.compareAndSetLongDouble(idx, currentAsLong, Double.isNaN(currentAsDouble = CdAtomicDoubleArray.toDouble(currentAsLong = this.bits.get(idx))) ? delta : currentAsDouble + delta)) {
        }
    }

    public double addAndGet(int i, double delta) {
        double currentAsDouble;
        double next;
        long currentAsLong;
        while (!this.compareAndSetLongDouble(i, currentAsLong = this.bits.get(i), next = (currentAsDouble = CdAtomicDoubleArray.toDouble(currentAsLong)) + delta)) {
        }
        return next;
    }

    public void clear() {
        int len = this.bits.length();
        for (int idx = 0; idx < len; ++idx) {
            this.bits.set(idx, ZERO);
        }
    }
}

