/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdTreeNode<T, K extends CdTreeNode<T, K>> {
    private final T data;
    @Nullable
    private final K parent;
    private final Map<T, K> children;

    public CdTreeNode(T data, @Nullable K parent) {
        this.data = data;
        this.parent = parent;
        this.children = new HashMap<T, K>();
    }

    public CdTreeNode() {
        this(null, null);
    }

    public K addChild(T child) {
        K childNode = this.createChildNode(child);
        this.children.put(child, childNode);
        return childNode;
    }

    @NotNull
    protected abstract K createChildNode(T var1);

    @Nullable
    public K getParent() {
        return this.parent;
    }

    public T getData() {
        return this.data;
    }

    public K getChild(T child) {
        return (K)((CdTreeNode)this.children.get(child));
    }

    public K getOrCreateChild(T child) {
        CdTreeNode node = (CdTreeNode)this.children.get(child);
        if (node != null) {
            return (K)node;
        }
        return this.addChild(child);
    }

    public void forEachChild(CdTreeNodeVisitor<K> visitor, Comparator<K> comparator) {
        ArrayList<K> sorted = new ArrayList<K>(this.children.values());
        sorted.sort(comparator);
        for (int i = 0; i < sorted.size(); ++i) {
            CdTreeNode child = (CdTreeNode)sorted.get(i);
            boolean ret = visitor.accept((CdTreeNode)child.getParent(), child, i);
            if (!ret) continue;
            child.forEachChild(visitor, comparator);
        }
    }

    @FunctionalInterface
    public static interface CdTreeNodeVisitor<K> {
        public boolean accept(K var1, K var2, int var3);
    }
}

