/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CdPair<FST, SND> {
    public FST fst;
    public SND snd;

    public CdPair(FST fst, SND snd) {
        this.fst = fst;
        this.snd = snd;
    }

    public FST getFst() {
        return this.fst;
    }

    public SND getSnd() {
        return this.snd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdPair pair = (CdPair)o;
        if (this.fst != null ? !this.fst.equals(pair.fst) : pair.fst != null) {
            return false;
        }
        return !(this.snd != null ? !this.snd.equals(pair.snd) : pair.snd != null);
    }

    public int hashCode() {
        int result = this.fst != null ? this.fst.hashCode() : 0;
        result = 31 * result + (this.snd != null ? this.snd.hashCode() : 0);
        return result;
    }

    public static <K, V> List<K> extractKeys(List<CdPair<K, V>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList keys = new ArrayList(pairs.size());
        for (CdPair<K, V> pair : pairs) {
            keys.add(pair.fst);
        }
        return keys;
    }

    public static <K, V> List<V> extractValues(List<CdPair<K, V>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList values = new ArrayList(pairs.size());
        for (CdPair<K, V> pair : pairs) {
            values.add(pair.snd);
        }
        return values;
    }

    @Nullable
    public static <E, K> K findByKey(List<CdPair<E, K>> pairs, E key) {
        if (pairs != null && key != null) {
            for (CdPair<E, K> pair : pairs) {
                if (!pair.fst.equals(key)) continue;
                return (K)pair.snd;
            }
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.fst) + " / " + String.valueOf(this.snd);
    }
}

