/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdISortedList;
import crazydev.common.collection.CdPaginatedList;
import crazydev.common.system.CdRamUsageEstimator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.RandomAccess;

public class CdPaginatedSortedList<T>
extends CdPaginatedList<T>
implements CdISortedList<T>,
RandomAccess {
    private final Comparator comparator;
    private static long SHALLOW_SIZE_OF = -1L;

    public CdPaginatedSortedList() {
        this(Comparator.naturalOrder());
    }

    public CdPaginatedSortedList(Comparator<T> comparator) {
        this(comparator, 2048);
    }

    public CdPaginatedSortedList(int default_max_array_size) {
        this(Comparator.naturalOrder(), default_max_array_size);
    }

    protected CdPaginatedSortedList(Comparator comparator, int default_max_array_size) {
        super(default_max_array_size, 2);
        this.comparator = comparator;
    }

    @Override
    public boolean add(T item) {
        int pageSize;
        if (this._size == 0L) {
            this.append(item);
            return true;
        }
        int page = this.hasSinglePage() ? 0 : this.binarySearchPage(item, this.comparator);
        Object[] pageArray = this._data[page];
        int pagePos = Arrays.binarySearch(pageArray, 0, pageSize = this._pos[page], item, this.comparator);
        if (pagePos >= 0) {
            while (++pagePos < pageSize && this.comparator.compare(item, pageArray[pagePos]) == 0) {
            }
            this.insertInternal(page, pagePos, item);
        } else {
            this.insertInternal(page, -pagePos - 1, item);
        }
        return true;
    }

    @Override
    public boolean addIfMissing(T item) {
        if (this._size == 0L) {
            this.append(item);
            return true;
        }
        int page = this.hasSinglePage() ? 0 : this.binarySearchPage(item, this.comparator);
        int pagePos = Arrays.binarySearch(this._data[page], 0, this._pos[page], item, this.comparator);
        if (pagePos >= 0) {
            return false;
        }
        this.insertInternal(page, -pagePos - 1, item);
        return true;
    }

    @Override
    public long getLongSize() {
        return this._size;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(Object item) {
        if (this._size == 0L) {
            return -1;
        }
        return this.binarySearch(item, this.comparator);
    }

    public int binarySearch(Object key, Comparator comparator) {
        int page = this.hasSinglePage() ? 0 : this.binarySearchPage(key, comparator);
        int pagePos = Arrays.binarySearch(this._data[page], 0, this._pos[page], key, comparator);
        if (pagePos >= 0) {
            return this._startPos[page] + pagePos;
        }
        return pagePos;
    }

    private int binarySearchPage(Object item, Comparator comparator) {
        int low = 0;
        int high = this.getLastPage();
        while (low <= high) {
            int mid = low + high >>> 1;
            Object[] page = this._data[mid];
            int comp = -comparator.compare(page[this._pos[mid] - 1], item);
            if (comp == 0) {
                return this.getLastMatching(mid, item, comparator);
            }
            if (comp > 0) {
                low = mid + 1;
                continue;
            }
            comp = -comparator.compare(page[0], item);
            if (comp == 0) {
                return mid;
            }
            if (comp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Math.max(0, low - 1);
    }

    private int getLastMatching(int page, Object item, Comparator comparator) {
        Object[] pageArray;
        int maxPage = this.getLastPage();
        for (int lookupPage = page + 1; lookupPage <= maxPage && comparator.compare((pageArray = this._data[lookupPage])[0], item) == 0; ++lookupPage) {
            page = lookupPage;
            if (comparator.compare(pageArray[this._pos[lookupPage] - 1], item) != 0) break;
        }
        return page;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public long shallowSizeOf() {
        long size;
        long l = size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(this));
        if (this._data != null) {
            size += CdRamUsageEstimator.shallowSizeOf((Object[])this._data);
            for (Object[] child : this._data) {
                if (child == null) continue;
                size += CdRamUsageEstimator.shallowSizeOf(child);
            }
        }
        if (this._startPos != null) {
            size += CdRamUsageEstimator.sizeOf(this._startPos);
        }
        if (this._pos != null) {
            size += CdRamUsageEstimator.sizeOf(this._pos);
        }
        return size;
    }
}

