/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdCollections;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdPaginatedList<T>
implements List<T> {
    private static final int DEFAULT_CAPACITY = 64;
    protected static final int DEFAULT_MAX_ARRAY_SIZE = 2048;
    protected static final int DEFAULT_MULTIPLIER = 2;
    private final int default_max_array_size;
    final int default_multiplier;
    protected Object[][] _data;
    protected int[] _startPos;
    protected int[] _pos;
    protected long _size;

    public CdPaginatedList() {
        this(2048, 2);
    }

    public CdPaginatedList(int default_max_array_size) {
        this(default_max_array_size, 2);
    }

    public CdPaginatedList(int default_max_array_size, int default_multiplier) {
        this.default_max_array_size = default_max_array_size;
        this.default_multiplier = default_multiplier;
        this.init();
        if (this.default_multiplier < 2) {
            throw new CdShouldNotBeHereProgrammingException("Algo will not work");
        }
    }

    private void init() {
        this._data = new Object[1][];
        this._data[0] = new Object[64];
        this._startPos = new int[1];
        this._pos = new int[1];
        this._size = 0L;
    }

    @Override
    public boolean add(T t) {
        return this.append(t);
    }

    protected boolean append(T val) {
        this.ensureCapacity();
        int page = this.getLastPage();
        this._data[page][this._pos[page]] = val;
        ++this._size;
        int n = page;
        this._pos[n] = this._pos[n] + 1;
        return true;
    }

    @Override
    public T get(int offset) {
        int page = this.getPage(offset);
        return (T)this._data[page][offset - this._startPos[page]];
    }

    @Nullable
    public T last() {
        if (this._size == 0L) {
            return null;
        }
        int lastPage = this.getLastPage();
        return (T)this._data[lastPage][this._pos[lastPage] - 1];
    }

    public boolean removeLastItem() {
        int pos;
        if (this._size == 0L) {
            return false;
        }
        int lastPage = this.getLastPage();
        this._pos[lastPage] = pos = this._pos[lastPage] - 1;
        this._data[lastPage][pos] = null;
        --this._size;
        if (pos == 0 && lastPage != 0) {
            int[] npos = new int[lastPage];
            System.arraycopy(this._pos, 0, npos, 0, lastPage);
            this._pos = npos;
        }
        return true;
    }

    @Override
    public void clear() {
        this.init();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean ret = false;
        for (T item : c) {
            ret |= this.add(item);
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return false;
    }

    @Override
    public int size() {
        return (int)this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0L;
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    protected boolean hasSinglePage() {
        return this._pos.length == 1;
    }

    protected final int getLastPage() {
        return this._pos.length - 1;
    }

    protected void insertInternal(int page, int offsetInArray, T value) {
        int pageOffset;
        if (page != 0 && offsetInArray == 0) {
            offsetInArray = this._pos[--page];
        }
        if ((pageOffset = this.ensureCapacity(page, this._pos[page] + 1)) >= 0) {
            page = this.getPage(pageOffset + Math.max(0, offsetInArray - 1));
            offsetInArray = pageOffset + offsetInArray - this._startPos[page];
        }
        int pageSize = this._pos[page];
        Object[] hitArray = this._data[page];
        System.arraycopy(hitArray, offsetInArray, hitArray, offsetInArray + 1, pageSize - offsetInArray);
        hitArray[offsetInArray] = value;
        this._pos[page] = pageSize + 1;
        ++this._size;
        int i = page + 1;
        while (i < this._pos.length) {
            int n = i++;
            this._startPos[n] = this._startPos[n] + 1;
        }
    }

    protected int getPage(int offset) {
        int low = 0;
        int high = this.getLastPage();
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this._startPos[mid];
            if (midVal < (long)offset) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(this){
            int page;
            int posInPage;
            boolean hasNext;
            final /* synthetic */ CdPaginatedList this$0;
            {
                CdPaginatedList cdPaginatedList = this$0;
                Objects.requireNonNull(cdPaginatedList);
                this.this$0 = cdPaginatedList;
                this.page = 0;
                this.posInPage = -1;
                this.hasNext = true;
            }

            @Override
            public boolean hasNext() {
                if (!this.hasNext) {
                    return false;
                }
                ++this.posInPage;
                while (this.posInPage >= this.this$0._pos[this.page]) {
                    if (++this.page >= this.this$0._pos.length) {
                        this.hasNext = false;
                        break;
                    }
                    this.posInPage = 0;
                }
                return this.hasNext;
            }

            @Override
            public T next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                return this.this$0._data[this.page][this.posInPage];
            }

            @Override
            public void remove() {
                throw new CdShouldNotBeHereProgrammingException();
            }
        };
    }

    public void trimToSize() {
        for (int i = 0; i < this._data.length; ++i) {
            Object[] d = this._data[i];
            int actualSize = this._pos[i];
            if (d.length <= actualSize) continue;
            Object[] temp = new Object[actualSize];
            System.arraycopy(d, 0, temp, 0, actualSize);
            this._data[i] = temp;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    private void ensureCapacity() {
        int page = this.getLastPage();
        this.ensureCapacity(page, this._pos[page] + 1);
    }

    private int ensureCapacity(int page, int capacity) {
        Object[] _array = this._data[page];
        if (capacity > _array.length) {
            if (capacity > this.default_max_array_size) {
                int index = this._startPos[page];
                this.addPage(page);
                return index;
            }
            int newCap = Math.min(this.default_max_array_size, Math.max(_array.length << 1, capacity));
            Object[] tmp = new Object[newCap];
            System.arraycopy(_array, 0, tmp, 0, _array.length);
            this._data[page] = tmp;
        }
        return -1;
    }

    protected void addPage(int page) {
        int newPages = this.default_multiplier - 1;
        int numPages = this._pos.length + newPages;
        Object[][] ndata = new Object[numPages][];
        int[] nstartPos = new int[numPages];
        int[] npos = new int[numPages];
        System.arraycopy(this._data, 0, ndata, 0, page);
        System.arraycopy(this._startPos, 0, nstartPos, 0, page);
        System.arraycopy(this._pos, 0, npos, 0, page);
        int start = page + 1;
        int nstart = start + newPages;
        int end = this._pos.length - start;
        System.arraycopy(this._data, start, ndata, nstart, end);
        System.arraycopy(this._startPos, start, nstartPos, nstart, end);
        System.arraycopy(this._pos, start, npos, nstart, end);
        start = 0;
        int sourceSize = this._pos[page];
        int sourceBlockSize = 1 + sourceSize / (newPages + 1);
        int startPos = this._startPos[page];
        for (int i = page; i < page + newPages + 1; ++i) {
            int size = Math.min(sourceBlockSize, sourceSize);
            if (i == page) {
                ndata[i] = this._data[page];
            } else {
                ndata[i] = new Object[this.default_max_array_size];
                System.arraycopy(this._data[page], start, ndata[i], 0, Math.min(this.default_max_array_size, size));
            }
            npos[i] = size;
            nstartPos[i] = startPos;
            startPos += size;
            start += size;
            sourceSize -= size;
        }
        Arrays.fill(this._data[page], sourceBlockSize, this._pos[page], (Object)0);
        if (sourceSize != 0) {
            throw new RuntimeException();
        }
        this._data = ndata;
        this._pos = npos;
        this._startPos = nstartPos;
    }

    @Override
    public boolean remove(Object o) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] asArray = new Object[this.size()];
        for (int ii = 0; ii < this.size(); ++ii) {
            asArray[ii] = this.get(ii);
        }
        return asArray;
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(T1[] a) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public T set(int index, T element) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public void add(int index, T element) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public T remove(int index) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public int indexOf(Object o) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        CdCollections.subListRangeCheck(fromIndex, toIndex, this.size());
        ArrayList<T> subList = new ArrayList<T>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            subList.add(this.get(i));
        }
        return subList;
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        throw new CdShouldNotBeHereProgrammingException();
    }
}

