/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdIIntArrayList;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdArrayUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;

public class CdIntArrayList
extends IntArrayList
implements CdIIntArrayList {
    protected static long SHALLOW_SIZE_OF = -1L;

    public CdIntArrayList() {
    }

    public CdIntArrayList(int capacity) {
        super(capacity);
    }

    @Override
    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(this));
        return size += CdRamUsageEstimator.sizeOf(this.a);
    }

    @Override
    public void trimToSize() {
        super.trim();
    }

    @Override
    public int getInt(int offset) {
        if (offset >= this.size()) {
            return 0;
        }
        return super.getInt(offset);
    }

    @Override
    public int set(int offset, int val) {
        if (offset >= this.size()) {
            CdArrayUtils.resize(this, offset + 1);
        }
        return super.set(offset, val);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.a.length) {
            int newCap = Math.max(this.a.length * 3 / 2 + 1, capacity);
            int[] tmp = new int[newCap];
            System.arraycopy(this.a, 0, tmp, 0, this.a.length);
            this.a = tmp;
        }
    }
}

