/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.collection.CdIComparableList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CdComparableList<T extends Comparable>
extends ArrayList<T>
implements CdIComparableList<T> {
    public CdComparableList(int initialCapacity) {
        super(initialCapacity);
    }

    public CdComparableList(List<T> values) {
        super(values);
    }

    @Override
    public CdComparableArray toComparableArray() {
        return new CdComparableArray(this.toArray(new Comparable[this.size()]));
    }

    @Override
    public void forEachNested(Consumer<? super T> consumer) {
        this.forEach((? super E t) -> {
            if (t instanceof CdIComparableList) {
                CdIComparableList list = (CdIComparableList)t;
                list.forEachNested(consumer);
            } else {
                consumer.accept(t);
            }
        });
    }

    public int compareTo(@NotNull Object o) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public void addIfNotPresent(T comparable) {
        if (this.indexOf(comparable) < 0) {
            this.add(comparable);
        }
    }

    @Override
    public Stream<T> stream() {
        return super.stream();
    }

    @Override
    public boolean contains(T t) {
        return super.contains(t);
    }

    @Override
    public int indexOf(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return super.indexOf(o);
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Comparable arr = (Comparable)this.get(i);
            if (arr == null || !arr.getClass().isArray() || Array.getLength(o) != Array.getLength(arr)) continue;
            int len = Array.getLength(arr);
            for (int j = 0; j < len; ++j) {
                Object arrValue = Array.get(o, j);
                Object objArr = Array.get(arr, j);
                if ((arrValue != null || objArr == null) && (arrValue == null || arrValue.equals(objArr))) continue;
                return -1;
            }
            return i;
        }
        return -1;
    }
}

