/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdArrays;
import crazydev.common.collection.CdIComparableList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public final class CdComparableArray
implements Comparable,
CdIComparableList<Comparable> {
    private Comparable[] instance;

    public CdComparableArray(Comparable[] instance) {
        this.instance = instance;
    }

    public <T extends Comparable> CdComparableArray(List<T> list) {
        this.instance = list.toArray(new Comparable[list.size()]);
    }

    @Override
    public int size() {
        return this.instance.length;
    }

    @Override
    public Comparable get(int idx) {
        return this.instance[Math.min(this.instance.length - 1, idx)];
    }

    @Override
    public CdComparableArray toComparableArray() {
        return this;
    }

    public Comparable[] getArray() {
        return this.instance;
    }

    public int compareTo(Object o) {
        if (o instanceof CdComparableArray) {
            CdComparableArray oArray = (CdComparableArray)o;
            return CdArrays.compareTo(oArray.getArray(), this.getArray());
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdComparableArray that = (CdComparableArray)o;
        return Arrays.equals(this.instance, that.instance);
    }

    public int hashCode() {
        return this.instance != null ? Arrays.hashCode(this.instance) : 0;
    }

    public String toString() {
        return Arrays.toString(this.instance);
    }

    public void forEachUpdate(Function<Comparable, Comparable> transformer) {
        for (int i = 0; i < this.instance.length; ++i) {
            this.instance[i] = transformer.apply(this.instance[i]);
        }
    }

    @Override
    public void forEach(Consumer<? super Comparable> consumer) {
        for (int i = 0; i < this.instance.length; ++i) {
            consumer.accept(this.instance[i]);
        }
    }

    @Override
    public void forEachNested(Consumer<? super Comparable> consumer) {
        for (int i = 0; i < this.instance.length; ++i) {
            Comparable t = this.instance[i];
            if (t instanceof CdIComparableList) {
                ((CdIComparableList)t).forEachNested(consumer);
                continue;
            }
            consumer.accept(t);
        }
    }

    @Override
    public Stream<Comparable> stream() {
        return Arrays.stream(this.instance);
    }

    @Override
    public boolean contains(Comparable comparable) {
        return CdArrays.contains(this.instance, comparable);
    }

    public CdComparableArray expandNestedArrays() {
        int totalLenght = 0;
        boolean gotArray = false;
        for (int i = 0; i < this.instance.length; ++i) {
            boolean isArray = this.instance[i] instanceof CdComparableArray;
            totalLenght += isArray ? ((CdComparableArray)this.instance[i]).size() : 1;
            gotArray |= isArray;
        }
        if (gotArray) {
            ArrayList listItems = new ArrayList(totalLenght);
            this.forEachNested((Consumer<? super Comparable>)((Consumer<Comparable>)listItems::add));
            return new CdComparableArray(listItems);
        }
        return this;
    }

    public void addValue(Comparable value) {
        this.instance = (Comparable[])ArrayUtils.add((Object[])this.instance, (Object)value);
    }
}

