/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class CdArrayList<T>
extends ArrayList<T> {
    private static final int MIN_ARRAY_SORT_GRAN = 8192;
    private static final long serialVersionUID = 1609218840809456034L;

    public CdArrayList() {
    }

    public CdArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public T set(int index, T element) {
        if (index >= this.size()) {
            this.ensureCapacity(index + 1);
            int itemsToAdd = index - this.size();
            for (int i = 0; i < itemsToAdd; ++i) {
                this.add(null);
            }
            this.add(element);
            return element;
        }
        return super.set(index, element);
    }

    @Nullable
    public T getExtra(int index, @Nullable T offSizeValue) {
        if (index >= this.size()) {
            return offSizeValue;
        }
        try {
            return (T)super.get(index);
        }
        catch (IndexOutOfBoundsException ex) {
            return offSizeValue;
        }
    }

    public void addIfNotPresent(T member) {
        if (!this.contains(member)) {
            this.add(member);
        }
    }

    public void parallelSort(Comparator<? super T> cmp) {
        if (this.size() > 8192) {
            try {
                Field unsafeField = ArrayList.class.getDeclaredField("elementData");
                unsafeField.setAccessible(true);
                Object[] elementData = (Object[])unsafeField.get(this);
                Arrays.parallelSort(elementData, 0, this.size(), cmp);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sort(cmp);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        for (Object t : this) {
            if (t == null) continue;
            action.accept(t);
        }
    }

    public T setIfAbsent(int index, Function<Integer, T> builder) {
        T t = this.getExtra(index, null);
        if (t == null) {
            t = builder.apply(index);
            this.set(index, t);
        }
        return t;
    }
}

