/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.cache;

import crazydev.common.collection.CdPair;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.Seconds;

public class CdSoylentGreenMap<KEY, VALUE> {
    private final HashMap<KEY, CdPair<VALUE, LocalDateTime>> cache = new HashMap();
    private final int lifespan;
    private final Object LOCK = new Object();

    CdSoylentGreenMap(int lifespanSeconds) {
        this.lifespan = lifespanSeconds;
    }

    public static <KEY, VALUE> CdSoylentGreenMap<KEY, VALUE> createMinutes(int minutes) {
        return new CdSoylentGreenMap<KEY, VALUE>(minutes * 60);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VALUE get(KEY key) {
        CdPair<VALUE, LocalDateTime> pair;
        Object object = this.LOCK;
        synchronized (object) {
            pair = this.cache.get(key);
        }
        return this.value(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VALUE put(KEY key, VALUE value) {
        CdPair<VALUE, LocalDateTime> pair;
        LocalDateTime now = LocalDateTime.now();
        Object object = this.LOCK;
        synchronized (object) {
            this.cache.entrySet().removeIf(entry -> Seconds.secondsBetween((ReadablePartial)((ReadablePartial)((CdPair)entry.getValue()).snd), (ReadablePartial)now).getSeconds() > this.lifespan);
            pair = this.cache.put(key, new CdPair<VALUE, LocalDateTime>(value, now));
        }
        return this.value(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(KEY key) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cache.remove(key);
        }
    }

    public int size() {
        return this.cache.size();
    }

    @Nullable
    private VALUE value(CdPair<VALUE, LocalDateTime> pair) {
        return pair == null ? null : (VALUE)pair.fst;
    }
}

