/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.cache;

import crazydev.common.cache.CdLRUCacheI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

class CdLRUCacheWithoutLRU<KEY, VALUE>
implements CdLRUCacheI<KEY, VALUE> {
    private final int lruMaxSize;
    private final int expectedMaxSize;
    private Map<KEY, VALUE> cache;
    @Nullable
    private KEY prevValueKey;
    @Nullable
    private VALUE prevValue;
    private boolean lru;

    public CdLRUCacheWithoutLRU(int lruMaxSize, int expectedMaxSize) {
        this.lruMaxSize = lruMaxSize;
        this.expectedMaxSize = expectedMaxSize;
        this.cache = new HashMap<KEY, VALUE>();
    }

    @Override
    public String getTypeInfo() {
        if (this.lru) {
            return "LRU:" + this.lruMaxSize + "(*)";
        }
        return "MAP:" + this.expectedMaxSize;
    }

    @Override
    public void nil() {
    }

    @Override
    public void put(KEY key, VALUE value) {
        this.cache.put(key, value);
        if (!this.lru && this.cache.size() > this.expectedMaxSize && this.cache.size() > this.lruMaxSize) {
            this.cache = new LinkedHashMap<KEY, VALUE>(this, 16, 0.75f, true){
                final /* synthetic */ CdLRUCacheWithoutLRU this$0;
                {
                    CdLRUCacheWithoutLRU cdLRUCacheWithoutLRU = this$0;
                    Objects.requireNonNull(cdLRUCacheWithoutLRU);
                    this.this$0 = cdLRUCacheWithoutLRU;
                    super(arg0, arg1, arg2);
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<KEY, VALUE> eldest) {
                    return this.size() > this.this$0.lruMaxSize;
                }
            };
            this.lru = true;
        }
    }

    @Override
    @Nullable
    public VALUE get(KEY key) {
        return this.cache.get(key);
    }

    @Override
    public void putPrev(KEY key, VALUE value) {
        this.prevValueKey = key;
        this.prevValue = value;
    }

    @Override
    @Nullable
    public VALUE getPrev(KEY key) {
        if (key.equals(this.prevValueKey)) {
            return this.prevValue;
        }
        return null;
    }

    @Override
    public void onProcessingCompleted() {
        this.prevValueKey = null;
        this.prevValue = null;
        this.cache.clear();
    }

    public String toString() {
        return this.getTypeInfo();
    }
}

