/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.cache;

import crazydev.common.cache.CdLRUCacheListener;
import org.jetbrains.annotations.Nullable;

public class CdLRUCacheStats
implements CdLRUCacheListener {
    private final String name;
    private final boolean withBridge;
    private final boolean withLT;
    private long resolveMemberNil;
    private long resolveMemberPrevHit;
    private long resolveMemberCacheHit;
    private long resolveMemberCacheMiss;
    private String typeInfo = "";

    public CdLRUCacheStats(String name, boolean withBridge, boolean withLT) {
        this.name = name;
        this.withBridge = withBridge;
        this.withLT = withLT;
    }

    public static CdLRUCacheStats[] merge(@Nullable CdLRUCacheStats[] to, CdLRUCacheStats[] from) {
        if (to == null) {
            to = new CdLRUCacheStats[from.length];
            System.arraycopy(from, 0, to, 0, to.length);
            return to;
        }
        for (int ii = 0; ii < to.length; ++ii) {
            CdLRUCacheStats totalStats = to[ii];
            CdLRUCacheStats fromStats = from[ii];
            totalStats.resolveMemberNil += fromStats.resolveMemberNil;
            totalStats.resolveMemberPrevHit += fromStats.resolveMemberPrevHit;
            totalStats.resolveMemberCacheHit += fromStats.resolveMemberCacheHit;
            totalStats.resolveMemberCacheMiss += fromStats.resolveMemberCacheMiss;
        }
        return to;
    }

    public String getName() {
        return this.name;
    }

    public boolean isWithBridge() {
        return this.withBridge;
    }

    public boolean isWithLT() {
        return this.withLT;
    }

    public String getTypeInfo() {
        return this.typeInfo;
    }

    public CdLRUCacheStats withTypeInfo(String typeInfo) {
        this.typeInfo = typeInfo;
        return this;
    }

    @Override
    public void onNil(long nil) {
        this.resolveMemberNil += nil;
    }

    @Override
    public void onPrevHit(long hit) {
        this.resolveMemberPrevHit += hit;
    }

    @Override
    public void onHit(long hit) {
        this.resolveMemberCacheHit += hit;
    }

    @Override
    public void onMiss(long miss) {
        this.resolveMemberCacheMiss += miss;
    }

    public long getResolveMemberNil() {
        return this.resolveMemberNil;
    }

    public long getResolveMemberPrevHit() {
        return this.resolveMemberPrevHit;
    }

    public long getResolveMemberCacheHit() {
        return this.resolveMemberCacheHit;
    }

    public long getResolveMemberCacheMiss() {
        return this.resolveMemberCacheMiss;
    }
}

