/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.cache;

import crazydev.common.cache.CdLRUCacheI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

class CdLRUCache<KEY, VALUE>
implements CdLRUCacheI<KEY, VALUE> {
    private final int maxSize;
    @Nullable
    private KEY prevValueKey;
    private final Map<KEY, VALUE> cache;
    @Nullable
    private VALUE prevValue;

    public CdLRUCache(final int maxSize) {
        this.cache = new LinkedHashMap<KEY, VALUE>(this, 16, 0.75f, true){
            final /* synthetic */ CdLRUCache this$0;
            {
                CdLRUCache cdLRUCache = this$0;
                Objects.requireNonNull(cdLRUCache);
                this.this$0 = cdLRUCache;
                super(arg0, arg1, arg2);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<KEY, VALUE> eldest) {
                return this.size() > maxSize;
            }
        };
        this.maxSize = maxSize;
    }

    @Override
    public String getTypeInfo() {
        return "LRU:" + this.maxSize;
    }

    @Override
    public void nil() {
    }

    @Override
    public void put(KEY key, VALUE value) {
        this.cache.put(key, value);
    }

    @Override
    @Nullable
    public VALUE get(KEY key) {
        return this.cache.get(key);
    }

    @Override
    public void putPrev(KEY key, VALUE value) {
        this.prevValueKey = key;
        this.prevValue = value;
    }

    @Override
    @Nullable
    public VALUE getPrev(KEY key) {
        if (key.equals(this.prevValueKey)) {
            return this.prevValue;
        }
        return null;
    }

    @Override
    public void onProcessingCompleted() {
        this.prevValueKey = null;
        this.prevValue = null;
        this.cache.clear();
    }

    public String toString() {
        return this.getTypeInfo();
    }
}

