/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.babylon;

import crazydev.common.utils.CdStringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class CdBabylonUtils {
    public static String translate(Locale locale, String bundleName, String tag, Serializable ... params) {
        return CdBabylonUtils.translate(Collections.emptySet(), locale, bundleName, null, tag, params);
    }

    public static String translate(Set<String> missings, Locale locale, String bundleName, @Nullable ClassLoader classLoader, String tag, Serializable ... params) {
        try {
            LocalizedValue value = CdBabylonUtils.doTranslate(missings, locale, bundleName, classLoader, tag, params);
            return value.value;
        }
        catch (MissingResourceException ex) {
            LocalizedValue value = CdBabylonUtils.formatOnError(tag, params);
            return value.value;
        }
    }

    public static String translate(Set<String> missings, Locale locale, Class localization, List<Class> alternateLocalizations, String tag, Serializable ... params) {
        LocalizedValue localized = CdBabylonUtils.translate(missings, locale, localization, tag, params);
        if (!localized.onError) {
            return localized.value;
        }
        if (alternateLocalizations.isEmpty()) {
            missings.add(tag);
            return localized.value;
        }
        for (Class alternateLocalization : alternateLocalizations) {
            LocalizedValue alternate = CdBabylonUtils.translate(missings, locale, alternateLocalization, tag, params);
            if (alternate.onError) continue;
            return alternate.value;
        }
        missings.add(tag);
        return localized.value;
    }

    private static LocalizedValue translate(Set<String> missings, Locale locale, Class localization, String tag, Serializable ... params) {
        Class clazz = localization;
        String bundle = clazz.getName();
        ClassLoader cl = clazz.getClassLoader();
        try {
            return CdBabylonUtils.doTranslate(missings, locale, bundle, cl, tag, params);
        }
        catch (MissingResourceException ex) {
            return CdBabylonUtils.formatOnError(tag, params);
        }
    }

    private static LocalizedValue doTranslate(Set<String> missings, Locale locale, String bundleName, @Nullable ClassLoader classLoader, String tag, Serializable ... params) {
        if (CdStringUtils.isNullOrBlank(tag)) {
            return new LocalizedValue("", false);
        }
        ResourceBundle bundle = CdBabylonUtils.getResourceBundle(locale, bundleName, classLoader);
        try {
            String format;
            if (missings.contains(tag)) {
                format = tag;
            } else {
                format = bundle.getString(tag);
                if (format != null && format.trim().length() == 0) {
                    format = tag;
                }
            }
            if (params != null && params.length > 0) {
                return CdBabylonUtils.format(locale, tag, format, params);
            }
            return new LocalizedValue(format, false);
        }
        catch (MissingResourceException ignored) {
            String format = tag;
            if (params != null && params.length > 0) {
                LocalizedValue localized = CdBabylonUtils.format(locale, tag, format, params);
                return new LocalizedValue(localized.value, true);
            }
            return new LocalizedValue(format, true);
        }
    }

    private static LocalizedValue format(Locale locale, String tag, String format, Serializable ... params) {
        LocalizedValue formattedTagValue;
        if (tag != format) {
            try {
                formattedTagValue = new LocalizedValue(String.format(locale, format, (Object[])params), false);
            }
            catch (IllegalFormatException ex) {
                formattedTagValue = CdBabylonUtils.formatOnError(tag, params);
            }
        } else {
            formattedTagValue = CdBabylonUtils.formatOnError(tag, params);
        }
        return formattedTagValue;
    }

    private static LocalizedValue formatOnError(String format, Serializable ... params) {
        return new LocalizedValue(CdBabylonUtils.translateWithNoResourceBundle(format, params), true);
    }

    public static String translateWithNoResourceBundle(String format, Serializable ... params) {
        if (params == null || params.length == 0) {
            return format;
        }
        return format + " " + Arrays.toString(params);
    }

    public static ResourceBundle getResourceBundle(Locale locale, String bundleName, @Nullable ClassLoader classLoader) {
        try {
            if (classLoader != null) {
                return ResourceBundle.getBundle(bundleName, locale, classLoader);
            }
            return ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException ex) {
            try {
                if (classLoader != null) {
                    return ResourceBundle.getBundle(bundleName, Locale.ENGLISH, classLoader);
                }
                return ResourceBundle.getBundle(bundleName, Locale.ENGLISH);
            }
            catch (MissingResourceException ignored) {
                throw ex;
            }
        }
    }

    static class LocalizedValue {
        final String value;
        final boolean onError;

        LocalizedValue(String value, boolean onError) {
            this.value = value != null ? value.trim() : "";
            this.onError = onError;
        }
    }
}

