/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.babylon;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class CdBabylonService {
    protected static final String DESCRIPTION = ".description";
    private static final String ORDER = ".order";
    protected final Set<String> missings = new HashSet<String>();

    public abstract Locale getLocale();

    public abstract String translate(String var1, Serializable ... var2);

    public String translateYesNo(boolean flag) {
        return flag ? this.translate("yes", new Serializable[0]) : this.translate("no", new Serializable[0]);
    }

    public String translatePropertyLabel(String propertyName) {
        return this.translate(propertyName, new Serializable[0]);
    }

    public String translateEnum(Class<?> enumType, String name) {
        String tag = enumType.getSimpleName() + "." + name;
        String label = this.translate(tag, new Serializable[0]);
        return label;
    }

    public String translate(Enum<?> en) {
        String tag = en.getDeclaringClass().getSimpleName() + "." + en.name();
        String label = this.translate(tag, new Serializable[0]);
        return label;
    }

    @Nullable
    public String translateEnumDescription(Class<?> enumType, String name) {
        String tag = enumType.getSimpleName() + "." + name + DESCRIPTION;
        String label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        return null;
    }

    public Integer getOrder(String baseTag) {
        String tag = baseTag + ORDER;
        String orderValue = this.translate(tag, new Serializable[0]);
        if (orderValue != null) {
            try {
                return Integer.valueOf(orderValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String translateUseCaseCaption(String tag, Serializable ... params) {
        return this.translate("useCase.caption." + tag, params);
    }

    @Nullable
    public String translateUseCaseCaptionHelpTooltip(String id) {
        String tag = "useCase.caption." + id + ".helpTooltip";
        String label = this.translate(tag, new Serializable[0]);
        if (label != tag) {
            return label;
        }
        return null;
    }
}

