/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.session;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.xmla.model.message.session.XmlaBeginSessionQuery;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.engine.XmlaQuerySessionContext;
import crazydev.xmla.server.iccube.server.message.XmlaQueryHandler;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.session.XmlaBeginSessionResponse;
import jakarta.servlet.http.HttpSession;

public class XmlaBeginSessionQueryHandler
extends XmlaQueryHandler<XmlaBeginSessionQuery> {
    @Override
    protected XmlaResponse doHandle(XmlaQueryContext context, XmlaBeginSessionQuery request) {
        XmlaQuerySessionContext sessionContext;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"XMLA : executing BeginSession");
        }
        if ((sessionContext = context.getXmlaQuerySessionContext()) == null) {
            throw new CdProgrammingException("internal error: missing XMLA session");
        }
        HttpSession httpSession = sessionContext.getHttpSession();
        if (httpSession != null) {
            if (OlapLoggers.SESSIONS.isInfoEnabled()) {
                OlapLoggers.SESSIONS.info((Object)("[session] XMLA session bound to HTTP session [ session-context:" + sessionContext.getSessionId() + " / http-session:" + httpSession.getId() + " ]"));
            }
            httpSession.setAttribute("icCubeServer.xmlaSessionContext", (Object)sessionContext.getSessionId());
        }
        return new XmlaBeginSessionResponse(sessionContext.getSessionId());
    }

    @Override
    protected XmlaResponse doHandleForPrepare(XmlaQueryContext context, XmlaBeginSessionQuery request) {
        throw new RuntimeException("internal error : ExecutionMode=Prepare not supported for BeginSession");
    }
}

