/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute.dmv;

import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.message.discover.XmlaDiscoverQuery;
import crazydev.xmla.model.message.execute.XmlaDmvStatementCommandQuery;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSet;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSetFactory;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.discover.XmlaDiscoverRequestMethodCallers;
import crazydev.xmla.server.iccube.server.message.discover.XmlaDiscoverResponse;
import crazydev.xmla.server.iccube.server.message.execute.dmv.XmlaDmvRestriction;
import crazydev.xmla.server.iccube.server.message.execute.dmv.XmlaDmvSystemTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.ArrayConstructor;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectItem;

public class XmlaDmvStatement {
    private final XmlaDmvStatementCommandQuery request;
    private final XmlaDmvSystemTable sysTable;
    private final List<String> fields;
    private final XmlaDmvRestriction restrictions;

    public XmlaDmvStatement(XmlaDmvStatementCommandQuery request, XmlaDmvSystemTable sysTable, List<String> fields, XmlaDmvRestriction restrictions) {
        this.request = request;
        this.sysTable = sysTable;
        this.fields = fields;
        this.restrictions = restrictions;
    }

    public static XmlaDmvStatement fromRequest(XmlaDmvStatementCommandQuery request) throws JSQLParserException {
        String statement = request.getStatement();
        PlainSelect select = (PlainSelect)CCJSqlParserUtil.parse((String)statement);
        Table table = (Table)select.getFromItem();
        XmlaDmvSystemTable sysTable = XmlaDmvSystemTable.lookupTable(table.getFullyQualifiedName());
        if (sysTable == null) {
            throw new JSQLParserException("Unexpected table [" + table.getFullyQualifiedName() + "]");
        }
        ArrayList<String> fields = new ArrayList<String>();
        List columns = select.getSelectItems();
        for (SelectItem column : columns) {
            Expression item;
            ArrayConstructor exprAC;
            ExpressionList items;
            Expression expr = column.getExpression();
            if (expr instanceof ArrayConstructor && (items = (exprAC = (ArrayConstructor)expr).getExpressions()).size() == 1 && (item = (Expression)items.getFirst()) instanceof Column) {
                Column itemC = (Column)item;
                fields.add(itemC.getColumnName());
                continue;
            }
            throw new JSQLParserException("Unexpected column expression [" + String.valueOf(column) + "]");
        }
        XmlaDmvRestriction restrictions = XmlaDmvRestriction.fromExpr(select.getWhere());
        return new XmlaDmvStatement(request, sysTable, fields, restrictions);
    }

    public XmlaDiscoverResponse execute(XmlaQueryContext context) {
        String rowSetName = this.sysTable.getRowSet();
        XmlaDiscoverQuery discover = new XmlaDiscoverQuery(this.request.getClientUUID(), this.request.getSessionId(), rowSetName, Collections.emptyList(), this.request.getProperties());
        List<? extends IXmlaDiscover> rowSetData = XmlaDiscoverRequestMethodCallers.getDiscoverAnswer(context, discover);
        XmlaDiscoverRowSet rowSetDef = XmlaDiscoverRowSetFactory.getExisting(rowSetName);
        ArrayList<IXmlaDiscover> rowSetDataF = new ArrayList<IXmlaDiscover>();
        for (IXmlaDiscover iXmlaDiscover : rowSetData) {
            boolean accepted = this.restrictions.accept(rowSetDef, iXmlaDiscover);
            if (!accepted) continue;
            rowSetDataF.add(iXmlaDiscover);
        }
        XmlaDiscoverRowSet rowSetDefF = rowSetDef.filter(this.fields);
        return new XmlaDiscoverResponse(true, this.request.getSessionId(), discover, rowSetDefF, rowSetDataF);
    }
}

