/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.schemas.OlapSchemaFactoryInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformationEx;
import crazydev.iccube.request.status.IcCubeRequestStatus;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaListSchemaExStatementCommandQuery;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.types.XmlaFormat;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaListSchemaManagementMDDataSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaListSchemaManagementRowSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaManagementApiQueryHandler;
import crazydev.xmla.server.iccube.server.message.common.XmlaMdxResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteMDDataSetResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteRowSetResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class XmlaListSchemaExStatementCommandQueryHandler
extends XmlaManagementApiQueryHandler<XmlaListSchemaExStatementCommandQuery> {
    @Override
    protected XmlaResponse doExecuteOlapEngineRequest(XmlaQueryContext context, XmlaListSchemaExStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        OlapEngineComponent engine = requestContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = requestContext.asRuntimeContext();
        IcCubeRequestStatusManager requests = requestContext.getRequestStatusManager();
        List infos = engine.listSchemaEx(rContext);
        HashSet<File> files = new HashSet<File>();
        for (OlapSchemaInformationEx info : infos) {
            files.add(info.getFactoryFile());
        }
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        olapEngine.foreachSchemaFactoryFile(requestContext.asRuntimeContext(), factoryFile -> {
            if (!files.contains(factoryFile)) {
                OlapSchemaFactoryInfo info = olapEngine.getSchemaFactoryInfo(requestContext.asRuntimeContext(), factoryFile);
                if (info != null) {
                    infos.add(new OlapSchemaInformationEx(OlapSchemaInformationEx.Status.UNLOADED, info.getName(), info.getFile()));
                } else {
                    infos.add(new OlapSchemaInformationEx(OlapSchemaInformationEx.Status.UNLOADED, null, factoryFile));
                }
            }
            return true;
        });
        ArrayList<IcCubeRequestStatus> activeSchemas = new ArrayList<IcCubeRequestStatus>();
        HashSet<String> loadingSchemas = new HashSet<String>();
        for (OlapSchemaInformationEx info : infos) {
            if (!info.isLoading()) continue;
            loadingSchemas.add(info.getName());
        }
        List actives = requests.getAllActiveLoadingSchemaRequestStatus(requestContext.getUserTenant());
        for (IcCubeRequestStatus active : actives) {
            String schema;
            if (!active.isLoadSchema() || !CdStringUtils.isNotNullAndNotBlank((String)(schema = active.getSchema())) || loadingSchemas.contains(schema)) continue;
            activeSchemas.add(active);
        }
        for (IcCubeRequestStatus activeSchema : activeSchemas) {
            infos.add(new OlapSchemaInformationEx(OlapSchemaInformationEx.Status.LOADING, activeSchema.getSchema(), activeSchema.getStartDate()));
        }
        OlapBabylonService babylon = context.getOlapEngineRequestContext().getBabylonService();
        IcCubeRequestStatusManager requestStatusManager = context.getRequestStatusManager();
        for (OlapSchemaInformationEx info : infos) {
            IcCubeRequestStatusManager.LatestErrors latestErrors;
            File factoryFile2 = info.getFactoryFile();
            if (factoryFile2 == null || (latestErrors = requestStatusManager.getLatestErrorsForSchemaDefFactory(factoryFile2)) == null) continue;
            info.setError((CdBabylonService)babylon, latestErrors);
        }
        return XmlaListSchemaExStatementCommandQueryHandler.createXmlaResponse(context, (XmlaExecuteQuery)request, infos);
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaListSchemaExStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        ArrayList<OlapSchemaInformationEx> loadedSchemaInfos = new ArrayList<OlapSchemaInformationEx>();
        return XmlaListSchemaExStatementCommandQueryHandler.createXmlaResponse(context, (XmlaExecuteQuery)request, loadedSchemaInfos);
    }

    public static XmlaMdxResponse createXmlaResponse(XmlaQueryContext context, XmlaExecuteQuery request, Iterable<OlapSchemaInformationEx> loadedSchemaInfos) {
        XmlaFormat format = request.getActualFormat();
        if (format == XmlaFormat.Tabular) {
            XmlaListSchemaManagementRowSet xmlaResult = new XmlaListSchemaManagementRowSet(loadedSchemaInfos, true);
            return new XmlaExecuteRowSetResponse(request.getSessionId(), request, (IXmlaRowSet)xmlaResult);
        }
        if (format == XmlaFormat.Multidimensional) {
            XmlaListSchemaManagementMDDataSet xmlaResult = new XmlaListSchemaManagementMDDataSet(loadedSchemaInfos, true);
            return new XmlaExecuteMDDataSetResponse(request.getSessionId(), request, xmlaResult);
        }
        throw new RuntimeException("internal error : unexpected XMLA response format [" + String.valueOf(format) + "]");
    }
}

