/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.execute;

import crazydev.iccube.cluster.master.backup.info.M_BackupInfo;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.xmla.model.message.execute.XmlaExecuteQuery;
import crazydev.xmla.model.message.execute.XmlaListSchemaBackupStatementCommandQuery;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.types.XmlaFormat;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import crazydev.xmla.server.iccube.server.message.common.XmlaListSchemaBackupManagementMDDataSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaListSchemaBackupManagementRowSet;
import crazydev.xmla.server.iccube.server.message.common.XmlaManagementApiQueryHandler;
import crazydev.xmla.server.iccube.server.message.common.XmlaMdxResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteMDDataSetResponse;
import crazydev.xmla.server.iccube.server.message.execute.XmlaExecuteRowSetResponse;
import java.util.ArrayList;
import java.util.List;

public class XmlaListSchemaBackupStatementCommandQueryHandler
extends XmlaManagementApiQueryHandler<XmlaListSchemaBackupStatementCommandQuery> {
    @Override
    protected XmlaResponse doExecuteOlapEngineRequest(XmlaQueryContext context, XmlaListSchemaBackupStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        OlapEngineRequestContext engineRequestContext = context.getOlapEngineRequestContext();
        M_BackupManager backupManager = engineRequestContext.getOrCreateBackupManager();
        String filter = request.getSchema();
        List backups = backupManager.getBackupInfos(filter);
        return XmlaListSchemaBackupStatementCommandQueryHandler.createXmlaResponse(context, (XmlaExecuteQuery)request, backups);
    }

    @Override
    protected XmlaResponse doExecuteOlapEngineRequestForPrepare(XmlaQueryContext context, XmlaListSchemaBackupStatementCommandQuery request, OlapEngineRequestContext requestContext) {
        ArrayList<M_BackupInfo> backups = new ArrayList<M_BackupInfo>();
        return XmlaListSchemaBackupStatementCommandQueryHandler.createXmlaResponse(context, (XmlaExecuteQuery)request, backups);
    }

    public static XmlaMdxResponse createXmlaResponse(XmlaQueryContext context, XmlaExecuteQuery request, Iterable<M_BackupInfo> backups) {
        XmlaFormat format = request.getActualFormat();
        if (format == XmlaFormat.Tabular) {
            XmlaListSchemaBackupManagementRowSet xmlaResult = new XmlaListSchemaBackupManagementRowSet(backups);
            return new XmlaExecuteRowSetResponse(request.getSessionId(), request, (IXmlaRowSet)xmlaResult);
        }
        if (format == XmlaFormat.Multidimensional) {
            XmlaListSchemaBackupManagementMDDataSet xmlaResult = new XmlaListSchemaBackupManagementMDDataSet(backups);
            return new XmlaExecuteMDDataSetResponse(request.getSessionId(), request, xmlaResult);
        }
        throw new RuntimeException("internal error : unexpected XMLA response format [" + String.valueOf(format) + "]");
    }
}

