/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.discover;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdClassUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.xmla.model.annotation.XmlaAnDiscoverType;
import crazydev.xmla.model.annotation.XmlaAnRowSet;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.message.discover.XmlaDiscoverQuery;
import crazydev.xmla.model.proxy.IXmlaProxy;
import crazydev.xmla.model.proxy.IXmlaRequestContext;
import crazydev.xmla.model.proxy.XmlaInvocationTargetProxyException;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import crazydev.xmla.server.iccube.server.message.discover.XmlaDiscoverRequestMethodCaller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class XmlaDiscoverRequestMethodCallers {
    private static final Map<String, XmlaDiscoverRequestMethodCaller> discoverRequestCalls = new HashMap<String, XmlaDiscoverRequestMethodCaller>();

    public static List<? extends IXmlaDiscover> getDiscoverAnswer(XmlaQueryContext context, XmlaDiscoverQuery discover) {
        XmlaDiscoverRequestMethodCaller caller = discoverRequestCalls.get(discover.getRequestType());
        if (caller != null) {
            return caller.getDiscoverOOAnswer(context, discover);
        }
        throw new CdRuntimeException("Discover type [" + discover.getRequestType() + "] is not supported yet");
    }

    static {
        for (final Method method : IXmlaProxy.class.getMethods()) {
            XmlaAnRowSet annotation = method.getAnnotation(XmlaAnRowSet.class);
            if (annotation == null) continue;
            String rowsetName = annotation.clazz().getAnnotation(XmlaAnDiscoverType.class).name();
            CdClassUtils.assertMethodParameterTypes((Method)method, (Class[])new Class[]{IXmlaRequestContext.class, List.class, List.class});
            CdClassUtils.assertMethodReturnType((Method)method, List.class, (Class[])new Class[]{annotation.clazz()});
            discoverRequestCalls.put(rowsetName, new XmlaDiscoverRequestMethodCaller(){

                @Override
                public List<? extends IXmlaDiscover> getDiscoverOOAnswer(XmlaQueryContext context, XmlaDiscoverQuery request) {
                    try {
                        List restrictions = request.getRestrictions();
                        List properties = request.getProperties();
                        XmlaServerProxy xmlaServerEngine = context.getXmlaEngine();
                        List result = (List)method.invoke((Object)xmlaServerEngine, context, restrictions, properties);
                        return result;
                    }
                    catch (IllegalAccessException ex) {
                        OlapLoggers.XMLA_REQUEST.error((Object)"DISCOVER error", (Throwable)ex);
                        throw new CdProgrammingException("Unexpected discover request!", (Throwable)ex);
                    }
                    catch (InvocationTargetException ex) {
                        OlapLoggers.XMLA_REQUEST.error((Object)"DISCOVER error", (Throwable)ex);
                        throw new XmlaInvocationTargetProxyException((Exception)ex);
                    }
                }
            });
        }
    }
}

