/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.common;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.script.OlapResScriptInfo;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.rowset.IXmlaRowSetDataRow;
import crazydev.xmla.model.rowset.XmlaAbstractRowSet;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.ArrayList;
import java.util.List;

public class XmlaScriptRowSet
extends XmlaAbstractRowSet {
    private final Title title;
    private final List<Info> info = new ArrayList<Info>();

    public XmlaScriptRowSet(CdBabylonService babylon, List<OlapResStatementDataSet> results) {
        this.title = new Title();
        for (OlapResStatementDataSet result : results) {
            OlapResScriptInfo details = result.asScriptResultInfo(babylon);
            this.info.add(new Info(this.title, details));
        }
    }

    public boolean isBlank() {
        return false;
    }

    public IXmlaRowSetDataRow getTitle() {
        return this.title;
    }

    public Iterable<? extends IXmlaRowSetDataRow> getRows() {
        return this.info;
    }

    static class Title
    implements IXmlaRowSetDataRow {
        private final List<OlapStringEntity> identifiers = new ArrayList<OlapStringEntity>();

        public Title() {
            this.identifiers.add(new OlapStringEntity("type"));
            this.identifiers.add(new OlapStringEntity("details"));
        }

        public int size() {
            return this.identifiers.size();
        }

        public String getXmlElementName(int col) {
            String name = this.identifiers.get(col).value();
            return CdXmlUtils.escapeForTagName((String)name);
        }

        public IXmlaPropertyValue get(int col) {
            OlapStringEntity name = this.identifiers.get(col);
            return new XmlaPropertyValue(false, CdXmlaSchemaType.DBTYPE_WSTR, name.asXmlaString());
        }
    }

    static class Info
    implements IXmlaRowSetDataRow {
        private final Title title;
        private final List<OlapScalarEntity> entities = new ArrayList<OlapScalarEntity>();

        public Info(Title title, OlapResScriptInfo details) {
            this.title = title;
            this.entities.add((OlapScalarEntity)new OlapStringEntity(details.getType()));
            this.entities.add((OlapScalarEntity)new OlapStringEntity(details.getDetails()));
        }

        public int size() {
            return this.title.size();
        }

        public String getXmlElementName(int col) {
            return this.title.getXmlElementName(col);
        }

        public IXmlaPropertyValue get(int col) {
            OlapScalarEntity entity = this.entities.get(col);
            return new XmlaPropertyValue(false, CdXmlaSchemaType.DBTYPE_WSTR, entity.asXmlaString());
        }
    }
}

