/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.common;

import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.message.property.XmlaContentProperty;
import crazydev.xmla.model.types.XmlaContent;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XmlaMdxResponse<T extends XmlaQuery>
extends XmlaResponse {
    @Nullable
    protected final String sessionId;
    protected final T request;

    protected XmlaMdxResponse(@Nullable String sessionId, T request) {
        this.sessionId = sessionId;
        this.request = request;
    }

    protected boolean isFromCacheResponse() {
        return false;
    }

    public boolean isEmptyResponse() {
        return false;
    }

    @Override
    protected final void doEmitSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException, IOException {
        if (this.isFromCacheResponse()) {
            this.doEmitFromCacheExecuteSoapEnvelopeBody(serializer);
            return;
        }
        if (this.isEmptyResponse()) {
            this.doEmitEmptyExecuteSoapEnvelopeBody(serializer);
            return;
        }
        this.doEmitRegularSoapEnvelopeBody(serializer);
    }

    protected void doEmitFromCacheExecuteSoapEnvelopeBody(XmlaSerializer serializer) throws IOException {
        throw new RuntimeException("internal error : inconsistent doEmitFromCacheExecuteSoapEnvelopeBody() usage of XMLA response");
    }

    private void doEmitRegularSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis");
        this.doEmitRegularSoapEnvelopeBodyXMLNS(attrs);
        serializer.startElement(null, null, this.getXMLRequest(), (Attributes)attrs);
        serializer.startElement(null, null, "return", null);
        AttributesImpl rootAttrs = new AttributesImpl();
        rootAttrs.addAttribute(null, null, "xmlns", "string", this.getReturnType());
        rootAttrs.addAttribute(null, null, "xmlns:xsi", "string", "http://www.w3.org/2001/XMLSchema-instance");
        rootAttrs.addAttribute(null, null, "xmlns:xsd", "string", "http://www.w3.org/2001/XMLSchema");
        serializer.startElement(null, null, "root", (Attributes)rootAttrs);
        if (this.isSchemaRequired()) {
            this.doEmitXmlaSchema(serializer);
        }
        if (this.isDataRequired()) {
            this.doEmitXmlaData(serializer);
        }
        serializer.endElement(null, null, "root");
        serializer.endElement(null, null, "return");
        serializer.endElement(null, null, this.getXMLRequest());
    }

    protected void doEmitRegularSoapEnvelopeBodyXMLNS(AttributesImpl attrs) {
    }

    protected boolean isSchemaRequired() {
        for (XmlaProperty property : this.request.getProperties()) {
            if (!(property instanceof XmlaContentProperty)) continue;
            XmlaContentProperty xproperty = (XmlaContentProperty)property;
            XmlaContent content = (XmlaContent)xproperty.getValue();
            return content.isSchemaRequired();
        }
        return true;
    }

    protected boolean isDataRequired() {
        for (XmlaProperty property : this.request.getProperties()) {
            if (!(property instanceof XmlaContentProperty)) continue;
            XmlaContentProperty xproperty = (XmlaContentProperty)property;
            XmlaContent content = (XmlaContent)xproperty.getValue();
            return content.isDataRequired();
        }
        return true;
    }

    protected abstract String getReturnType();

    protected abstract String getXMLRequest();

    protected abstract void doEmitXmlaSchema(XmlaSerializer var1) throws SAXException, IOException;

    protected abstract void doEmitXmlaData(XmlaSerializer var1) throws SAXException, IOException;
}

