/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message.common;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.xml.CdXmlUtils;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.schema.OlapSchemaInformationEx;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.rowset.IXmlaRowSetDataRow;
import crazydev.xmla.model.rowset.XmlaAbstractRowSet;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.ArrayList;
import java.util.List;

public class XmlaListSchemaManagementRowSet
extends XmlaAbstractRowSet {
    private final Title title;
    private final List<Info> info = new ArrayList<Info>();

    public XmlaListSchemaManagementRowSet(Iterable<OlapSchemaInformationEx> loadedSchemaInfos, boolean extended) {
        this.title = new Title(extended);
        for (OlapSchemaInformationEx loadedSchemaInfo : loadedSchemaInfos) {
            if (extended) {
                this.info.add(new Info(this.title, loadedSchemaInfo.getStatus(), loadedSchemaInfo.getName(), loadedSchemaInfo.getFactoryFileName(), loadedSchemaInfo.getRefreshTimeStart_UTC(), loadedSchemaInfo.getRefreshTimeEnd_UTC(), loadedSchemaInfo.getDataUpdateTimeEnd_UTC(), loadedSchemaInfo.getErrorTime_UTC(), loadedSchemaInfo.getError()));
                continue;
            }
            this.info.add(new Info(this.title, loadedSchemaInfo.getName(), loadedSchemaInfo.getFactoryFileName(), loadedSchemaInfo.getRefreshTimeEnd_UTC(), loadedSchemaInfo.getDataUpdateTimeEnd_UTC()));
        }
    }

    public boolean isBlank() {
        return false;
    }

    public IXmlaRowSetDataRow getTitle() {
        return this.title;
    }

    public Iterable<? extends IXmlaRowSetDataRow> getRows() {
        return this.info;
    }

    static class Title
    implements IXmlaRowSetDataRow {
        private final List<OlapStringEntity> identifiers = new ArrayList<OlapStringEntity>();

        public Title(boolean extended) {
            if (extended) {
                this.identifiers.add(new OlapStringEntity("Status"));
                this.identifiers.add(new OlapStringEntity("Name"));
                this.identifiers.add(new OlapStringEntity("Factory"));
                this.identifiers.add(new OlapStringEntity("RefreshTimeStartUTC"));
                this.identifiers.add(new OlapStringEntity("RefreshTimeEndUTC"));
                this.identifiers.add(new OlapStringEntity("UpdateDataTimeEndUTC"));
                this.identifiers.add(new OlapStringEntity("ErrorTimeUTC)"));
                this.identifiers.add(new OlapStringEntity("ErrorMessage"));
            } else {
                this.identifiers.add(new OlapStringEntity("Name"));
                this.identifiers.add(new OlapStringEntity("Factory"));
                this.identifiers.add(new OlapStringEntity("RefreshTimeUTC"));
                this.identifiers.add(new OlapStringEntity("UpdateDataTimeUTC"));
            }
        }

        public int size() {
            return this.identifiers.size();
        }

        public String getXmlElementName(int col) {
            String name = this.identifiers.get(col).value();
            return CdXmlUtils.escapeForTagName((String)name);
        }

        public IXmlaPropertyValue get(int col) {
            OlapStringEntity name = this.identifiers.get(col);
            return new XmlaPropertyValue(false, CdXmlaSchemaType.DBTYPE_WSTR, name.asXmlaString());
        }
    }

    static class Info
    implements IXmlaRowSetDataRow {
        private final Title title;
        private final List<OlapScalarEntity> entities = new ArrayList<OlapScalarEntity>();

        public Info(Title title, String ... infos) {
            this.title = title;
            for (String info : infos) {
                this.entities.add((OlapScalarEntity)new OlapStringEntity(info));
            }
        }

        public int size() {
            return this.title.size();
        }

        public String getXmlElementName(int col) {
            return this.title.getXmlElementName(col);
        }

        public IXmlaPropertyValue get(int col) {
            OlapScalarEntity entity = this.entities.get(col);
            return new XmlaPropertyValue(false, CdXmlaSchemaType.DBTYPE_WSTR, entity.asXmlaString());
        }
    }
}

