/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.xmla.model.common.XmlaConstants;
import crazydev.xmla.model.message.XmlaSerializer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.xml.serialize.OutputFormat;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XmlaResponse
implements XmlaConstants {
    public static final String CHARSET_ENCODING = "UTF-8";

    protected XmlaResponse() {
    }

    @Nullable
    public String getSessionId() {
        return null;
    }

    @Nullable
    public OlapSchemaLifeCycleStatus getSchemaLifeCycleStatus() {
        return null;
    }

    public final void emitContent(CdXmlaCaller caller, OutputStream out) {
        this.emitContent(caller, out, false);
    }

    public final void emitContent(CdXmlaCaller caller, OutputStream out, boolean soapBodyOnly) {
        try {
            this.emitSoapEnvelope(caller, out, soapBodyOnly);
        }
        catch (IOException | SAXException ex) {
            throw new CdRuntimeException((Throwable)ex, "SOAP response error");
        }
    }

    private void emitSoapEnvelope(CdXmlaCaller caller, OutputStream out, boolean soapBodyOnly) throws IOException, SAXException {
        BufferedWriter underlying = new BufferedWriter(new OutputStreamWriter(out, CHARSET_ENCODING));
        PrintWriter writer = new PrintWriter(underlying);
        OutputFormat format = this.createSerializerOutputFormat(true);
        XmlaSerializer serializer = this.createSerializer(caller, out, writer, format);
        serializer.startDocument();
        if (!soapBodyOnly) {
            AttributesImpl envelopeAttrs = new AttributesImpl();
            envelopeAttrs.addAttribute(null, null, "xmlns:soap", "string", "http://schemas.xmlsoap.org/soap/envelope/");
            serializer.startElement(null, null, "soap:Envelope", (Attributes)envelopeAttrs);
            this.emitSoapEnvelopeHeader(serializer);
        }
        this.emitSoapEnvelopeBody(serializer, soapBodyOnly);
        if (!soapBodyOnly) {
            serializer.endElement(null, null, "soap:Envelope");
        }
        serializer.endDocument();
        writer.flush();
    }

    protected XmlaSerializer createSerializer(CdXmlaCaller caller, @Nullable OutputStream out, PrintWriter writer, OutputFormat format) {
        return new XmlaSerializer(caller, out, writer, format);
    }

    protected OutputFormat createSerializerOutputFormat(boolean omitXmlDeclaration) {
        OutputFormat format = new OutputFormat("xml", CHARSET_ENCODING, false);
        format.setOmitXMLDeclaration(omitXmlDeclaration);
        format.setLineWidth(0);
        return format;
    }

    protected void emitSoapEnvelopeHeader(XmlaSerializer serializer) throws SAXException {
        if (this.getSessionId() != null) {
            serializer.startElement(null, null, "soap:Header", null);
            AttributesImpl sessionAttrs = new AttributesImpl();
            sessionAttrs.addAttribute(null, null, "SessionId", "string", this.getSessionId());
            sessionAttrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis");
            serializer.startElement(null, null, "Session", (Attributes)sessionAttrs);
            serializer.endElement(null, null, "Session");
            serializer.endElement(null, null, "soap:Header");
        }
    }

    protected final void emitSoapEnvelopeBody(XmlaSerializer serializer, boolean soapBodyOnly) throws SAXException, IOException {
        if (!soapBodyOnly) {
            serializer.startElement(null, null, "soap:Body", null);
        }
        this.doEmitSoapEnvelopeBody(serializer);
        if (!soapBodyOnly) {
            serializer.endElement(null, null, "soap:Body");
        }
    }

    protected void doEmitSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException, IOException {
    }

    protected void doEmitEmptyExecuteSoapEnvelopeBody(XmlaSerializer serializer) throws SAXException {
        AttributesImpl executeResponseAttrs = new AttributesImpl();
        executeResponseAttrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis");
        serializer.startElement(null, null, "ExecuteResponse", (Attributes)executeResponseAttrs);
        serializer.startElement(null, null, "return", null);
        AttributesImpl rootAttrs = new AttributesImpl();
        rootAttrs.addAttribute(null, null, "xmlns", "string", "urn:schemas-microsoft-com:xml-analysis:empty");
        serializer.startElement(null, null, "root", (Attributes)rootAttrs);
        serializer.endElement(null, null, "root");
        serializer.endElement(null, null, "return");
        serializer.endElement(null, null, "ExecuteResponse");
    }
}

