/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.message;

import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.pub.authorization.OlapMaxUserExceededException;
import crazydev.iccube.pub.authorization.OlapMissingRoleException;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.message.XmlaResponse;
import org.apache.log4j.Logger;

public abstract class XmlaQueryHandler<T extends XmlaQuery> {
    public static final Logger LOGGER = OlapLoggers.XMLA_REQUEST;

    protected XmlaQueryHandler() {
    }

    public final XmlaResponse handle(XmlaQueryContext context, T request) throws OlapRoleAuthorizationException {
        OlapRoleApplicationPermissions permissions;
        OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
        OlapEngineSessionContext olapEngineSessionContext = olapEngineRequestContext.getSessionContext();
        OlapPrincipal principal = olapEngineSessionContext.getUser();
        String roleName = principal.getRoleName();
        IOlapPermissionsService roleService = context.getRoleService();
        try {
            permissions = roleService.authorizeUserForApplications(principal);
        }
        catch (OlapMaxUserExceededException ex) {
            throw new OlapRoleAuthorizationRuntimeException("user/role [" + principal.getName() + "/" + roleName + "] is not authorized (missing role)");
        }
        catch (OlapMissingRoleException ex) {
            throw new OlapRoleAuthorizationRuntimeException("user/role [" + principal.getName() + "/" + roleName + "] is not authorized (user count)");
        }
        permissions.assertXmlaEnabled();
        this.assertRequestAuthorized(context, permissions, request);
        if (request.isExecutionModePrepare()) {
            return this.doHandleForPrepare(context, request);
        }
        return this.doHandle(context, request);
    }

    protected void assertRequestAuthorized(XmlaQueryContext context, OlapRoleApplicationPermissions permissions, T request) throws OlapRoleAuthorizationException {
    }

    protected abstract XmlaResponse doHandle(XmlaQueryContext var1, T var2);

    protected abstract XmlaResponse doHandleForPrepare(XmlaQueryContext var1, T var2);
}

