/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.engine;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.xmla.server.iccube.server.engine.XmlaQuerySessionContext;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
public class XmlaServerSessionManager {
    private final Map<String, XmlaQuerySessionContext> sessions = new ConcurrentHashMap<String, XmlaQuerySessionContext>();

    public int getSessionCount() {
        return this.sessions.size();
    }

    public XmlaQuerySessionContext createSession(@Nullable HttpSession httpSession, String sessionId) {
        XmlaQuerySessionContext session = new XmlaQuerySessionContext(httpSession, sessionId);
        if (OlapLoggers.SESSIONS.isInfoEnabled()) {
            OlapLoggers.SESSIONS.info((Object)("[session] XMLA session created [ " + sessionId + " ]"));
        }
        this.sessions.put(session.getSessionId(), session);
        return session;
    }

    @Nullable
    public XmlaQuerySessionContext getSession(@Nullable String sessionId) {
        if (sessionId == null) {
            return null;
        }
        return this.sessions.get(sessionId);
    }

    @Nullable
    public XmlaQuerySessionContext closeSession(@Nullable String sessionId) {
        if (OlapLoggers.SESSIONS.isInfoEnabled()) {
            OlapLoggers.SESSIONS.info((Object)("[session] XMLA session destroyed [ " + sessionId + " ]"));
        }
        if (sessionId != null) {
            return this.sessions.remove(sessionId);
        }
        return null;
    }
}

