/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.engine;

import crazydev.common.collection.CdCollections;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.ICdException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.lang.CdAbstractBitmapEnum;
import crazydev.common.lang.CdAbstractEnum;
import crazydev.common.lang.CdAbstractEnumHelper;
import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.common.mdx.CdMdxUtils;
import crazydev.common.mdx.error.CdMdxException;
import crazydev.common.utils.CdClassUtils;
import crazydev.common.utils.CdNetworkUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapPropertiesHelper;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescriptions;
import crazydev.iccube.configuration.component.properties.OlapVisualMode;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxStatementCompilationInfo;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapSchemaStaticSetFormulaEvaluationCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapMemberKey;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSetWrapper;
import crazydev.iccube.olap.entity.result.script.OlapResScriptDataSet;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilterHelper;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import crazydev.iccube.olap.eval.select.context.IOlapPrepareContext;
import crazydev.iccube.olap.eval.select.context.OlapExcelSetEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementWithCubeSelectExecutionContext;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.xmla.model.annotation.XmlaAnDiscoverType;
import crazydev.xmla.model.discover.IXmlaDBSchemaCatalogs;
import crazydev.xmla.model.discover.IXmlaDBSchemaTables;
import crazydev.xmla.model.discover.IXmlaDMSchemaMiningModels;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.discover.IXmlaDiscoverCsdlMetaData;
import crazydev.xmla.model.discover.IXmlaDiscoverDataSources;
import crazydev.xmla.model.discover.IXmlaDiscoverInstance;
import crazydev.xmla.model.discover.IXmlaDiscoverLiteral;
import crazydev.xmla.model.discover.IXmlaDiscoverProperties;
import crazydev.xmla.model.discover.IXmlaDiscoverSchemaRowSet;
import crazydev.xmla.model.discover.IXmlaDiscoverXmlMetaData;
import crazydev.xmla.model.discover.IXmlaMDSchemaAction;
import crazydev.xmla.model.discover.IXmlaMDSchemaCube;
import crazydev.xmla.model.discover.IXmlaMDSchemaDimension;
import crazydev.xmla.model.discover.IXmlaMDSchemaFunction;
import crazydev.xmla.model.discover.IXmlaMDSchemaHierarchy;
import crazydev.xmla.model.discover.IXmlaMDSchemaKPI;
import crazydev.xmla.model.discover.IXmlaMDSchemaLevel;
import crazydev.xmla.model.discover.IXmlaMDSchemaMeasure;
import crazydev.xmla.model.discover.IXmlaMDSchemaMeasureGroup;
import crazydev.xmla.model.discover.IXmlaMDSchemaMeasureGroupDimension;
import crazydev.xmla.model.discover.IXmlaMDSchemaMember;
import crazydev.xmla.model.discover.IXmlaMDSchemaProperty;
import crazydev.xmla.model.discover.IXmlaMDSchemaSet;
import crazydev.xmla.model.discover.bean.XmlaDBSchemaCatalogsBean;
import crazydev.xmla.model.discover.bean.XmlaDiscoverCsdlMetaDataBean;
import crazydev.xmla.model.discover.bean.XmlaDiscoverDataSourcesBean;
import crazydev.xmla.model.discover.bean.XmlaDiscoverPropertiesBean;
import crazydev.xmla.model.discover.bean.XmlaDiscoverSchemaRowSetBean;
import crazydev.xmla.model.discover.bean.XmlaDiscoverXmlMetaDataBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaActionBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaCubeBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaDimensionBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaHierarchyBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaLevelBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMeasureBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMeasureGroupBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMeasureGroupDimensionBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberProperties;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberProperty;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberPropertyValue;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaPropertyBean;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaSetBean;
import crazydev.xmla.model.mddataset.IXmlaMDDataSet;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaRestriction;
import crazydev.xmla.model.message.property.XmlaDbpropMsmdFlattened2Property;
import crazydev.xmla.model.message.property.XmlaLocaleIdentifierProperty;
import crazydev.xmla.model.message.property.XmlaUntypedProperty;
import crazydev.xmla.model.message.property.XmlaVisualModeProperty;
import crazydev.xmla.model.proxy.IXmlaProxy;
import crazydev.xmla.model.proxy.XmlaProxyException;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.types.XmlaActionInvocation;
import crazydev.xmla.model.types.XmlaActionType;
import crazydev.xmla.model.types.XmlaCoordinateType;
import crazydev.xmla.model.types.XmlaCubeSource;
import crazydev.xmla.model.types.XmlaCubeType;
import crazydev.xmla.model.types.XmlaDimensionType;
import crazydev.xmla.model.types.XmlaHChapterElement;
import crazydev.xmla.model.types.XmlaLevelType;
import crazydev.xmla.model.types.XmlaLiteral;
import crazydev.xmla.model.types.XmlaMeasureAggregator;
import crazydev.xmla.model.types.XmlaMemberType;
import crazydev.xmla.model.types.XmlaPropertyAccessType;
import crazydev.xmla.model.types.XmlaPropertyCardinality;
import crazydev.xmla.model.types.XmlaPropertyOrigin;
import crazydev.xmla.model.types.XmlaPropertyType;
import crazydev.xmla.model.types.XmlaPropertyVisibility;
import crazydev.xmla.model.types.XmlaSetEvaluationContext;
import crazydev.xmla.model.types.XmlaSetScope;
import crazydev.xmla.model.types.XmlaTreeOp;
import crazydev.xmla.model.types.XmlaVisualMode;
import crazydev.xmla.server.iccube.mddataset.XmlaCellPropertyManager;
import crazydev.xmla.server.iccube.mddataset.XmlaFunctionRepository;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowColumn;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSet;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSetFactory;
import crazydev.xmla.server.iccube.server.engine.XmlaQueryContext;
import crazydev.xmla.server.iccube.server.engine.XmlaQuerySessionContext;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxyException;
import crazydev.xmla.server.iccube.server.engine.XmlaServerSessionManager;
import crazydev.xmla.server.iccube.server.engine.helper.XmlaServerDataSetHelper;
import crazydev.xmla.server.iccube.server.engine.helper.XmlaServerDataSetScriptHelper;
import crazydev.xmla.server.iccube.server.engine.helper.XmlaServerRowSetHelper;
import crazydev.xmla.server.iccube.server.engine.helper.XmlaServerRowSetScriptHelper;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class XmlaServerProxy
implements IXmlaProxy<XmlaQuerySessionContext, XmlaQueryContext> {
    private static final String PROVIDER_NAME = "icCube";
    private static final String PROVIDER_VERSION = "16.0.42.209";
    private final XmlaServerSessionManager xmlaSessionManager = new XmlaServerSessionManager();

    private static Map<String, IXmlaDiscoverProperties> XMLA_PROPERTIES(CdXmlaCaller caller) {
        HashMap<String, IXmlaDiscoverProperties> XMLA_PROPERTIES = new HashMap<String, IXmlaDiscoverProperties>();
        XMLA_PROPERTIES.put("ProviderVersion", (IXmlaDiscoverProperties)new XmlaDiscoverPropertiesBean("ProviderVersion", "ProviderVersion", CdXmlaSchemaType.DBTYPE_WSTR, XmlaPropertyAccessType.Read, false, XmlaServerProxy.getProviderVersion()));
        XMLA_PROPERTIES.put("MdpropMdxSubqueries", (IXmlaDiscoverProperties)new XmlaDiscoverPropertiesBean("MdpropMdxSubqueries", "MdpropMdxSubqueries", CdXmlaSchemaType.DBTYPE_I4, XmlaPropertyAccessType.Read, false, "63"));
        return XMLA_PROPERTIES;
    }

    private static XmlaDiscoverPropertiesBean createCatalogXmlaProperty(String catalogName) {
        return new XmlaDiscoverPropertiesBean("Catalog", "Catalog", CdXmlaSchemaType.DBTYPE_WSTR, XmlaPropertyAccessType.ReadWrite, false, catalogName);
    }

    private static XmlaDiscoverPropertiesBean createXmlaProperty(OlapProperty olapProperty) {
        OlapPropertyDescription olapPropertyDescription = olapProperty.getDescription();
        return new XmlaDiscoverPropertiesBean(olapPropertyDescription.getName(), olapPropertyDescription.getName() + " ...", olapPropertyDescription.getXmlaType(), switch (olapPropertyDescription.getAccessType()) {
            case OlapPropertyAccessType.READ -> XmlaPropertyAccessType.Read;
            case OlapPropertyAccessType.READ_WRITE -> XmlaPropertyAccessType.ReadWrite;
            default -> throw new CdProgrammingException("Unrecognized [" + String.valueOf(olapPropertyDescription.getAccessType()) + "] property access type!");
        }, olapPropertyDescription.isRequired(), olapProperty.getXmlaValueAsString());
    }

    @Nullable
    public static CdXmlaOptions setupOptions(XmlaQueryContext context, String statement) {
        OlapProperties properties = context.getOlapEngineRequestContext().getOlapEngineProperties();
        if (statement.contains("__XL") && properties.isExcelFixXsdLong()) {
            return new CdXmlaOptions(true);
        }
        return null;
    }

    public static List<OlapProperty> createIcCubeProperties(List<XmlaProperty> xmlaProperties) {
        ArrayList<OlapProperty> olapProperties = new ArrayList<OlapProperty>();
        for (XmlaProperty xmlaProperty : xmlaProperties) {
            OlapProperty olapProperty;
            if (xmlaProperty instanceof XmlaLocaleIdentifierProperty || (olapProperty = XmlaServerProxy.createIcCubeProperty(xmlaProperty)) == null) continue;
            olapProperties.add(olapProperty);
        }
        return olapProperties;
    }

    @Nullable
    private static OlapProperty createIcCubeProperty(XmlaProperty xmlaProperty) {
        XmlaVisualModeProperty vm;
        OlapPropertyDescription description = OlapPropertyDescriptions.getDescription((String)xmlaProperty.getName());
        if (description != null) {
            if (description.getAccessType() != OlapPropertyAccessType.READ) {
                if (!(xmlaProperty instanceof XmlaUntypedProperty)) {
                    throw new CdProgrammingException();
                }
                XmlaUntypedProperty xmlaPropertyX = (XmlaUntypedProperty)xmlaProperty;
                try {
                    OlapProperty olapProperty = OlapPropertiesHelper.unmarshall((String)"XMLA request", (String)description.getName(), (String)((String)xmlaPropertyX.getValue()));
                    return olapProperty;
                }
                catch (OlapConfigurationException ignored) {
                    OlapLoggers.XMLA_REQUEST.warn((Object)("XMLA invalid property : " + description.getName()));
                    return null;
                }
            }
        } else if (xmlaProperty instanceof XmlaVisualModeProperty && (vm = (XmlaVisualModeProperty)xmlaProperty).getValue() == XmlaVisualMode.VISUAL_TOTAL) {
            return OlapPropertyDescriptions.visualMode.asProperty((Object)OlapVisualMode.VISUAL_TOTAL);
        }
        return null;
    }

    private static String getExistingPropertyValue(List<XmlaProperty> properties, String key) throws XmlaProxyException {
        String value = XmlaServerProxy.getPropertyValue(properties, key);
        if (value == null) {
            throw new XmlaServerProxyException("missing XMLA property [" + key + "]");
        }
        return value;
    }

    @Nullable
    private static String getPropertyValue(List<XmlaProperty> properties, String key) {
        String value = null;
        for (XmlaProperty property : properties) {
            String propertyName = property.getName();
            if (!propertyName.equals(key)) continue;
            value = property.toXmlaString();
        }
        return value;
    }

    @Nullable
    private static <T> T getPropertyValue(List<XmlaProperty> properties, Class<? extends XmlaProperty<T>> clazz, T defaultValue) {
        for (XmlaProperty property : properties) {
            if (!property.getClass().equals(clazz)) continue;
            return (T)property.getValue();
        }
        return defaultValue;
    }

    @Nullable
    private static XmlaRestriction getRestriction(List<XmlaRestriction> restrictions, String restrictionName) {
        for (XmlaRestriction restriction : restrictions) {
            if (!restriction.getName().equals(restrictionName)) continue;
            return restriction;
        }
        return null;
    }

    @Nullable
    private static List<XmlaRestriction> getRestrictions(List<XmlaRestriction> restrictions, String restrictionName) {
        ArrayList<XmlaRestriction> reqRestrictions = new ArrayList<XmlaRestriction>();
        for (XmlaRestriction restriction : restrictions) {
            if (!restriction.getName().equals(restrictionName)) continue;
            reqRestrictions.add(restriction);
        }
        return !reqRestrictions.isEmpty() ? reqRestrictions : null;
    }

    private static String getExistingRestrictionValue(List<XmlaRestriction> restrictions, String key) throws XmlaProxyException {
        String value = XmlaServerProxy.getRestrictionValue(restrictions, key);
        if (value == null) {
            throw new XmlaServerProxyException("missing XMLA restriction [" + key + "]");
        }
        return value;
    }

    @Nullable
    private static <T extends CdAbstractEnum> T getRestrictionValueAsEnum(List<XmlaRestriction> restrictions, String key, Class<T> clazz, @Nullable T defaultValue) {
        CdAbstractEnum value = null;
        for (XmlaRestriction restriction : restrictions) {
            String restrictionName = restriction.getName();
            if (!restrictionName.equals(key)) continue;
            String positionAsString = restriction.getValue();
            int position = Integer.parseInt(positionAsString);
            value = CdAbstractEnumHelper.fromPosition(clazz, (int)position);
        }
        return (T)(value == null ? defaultValue : value);
    }

    @Nullable
    private static Integer getRestrictionValueAsInteger(List<XmlaRestriction> restrictions, String key) {
        String valueAsString = XmlaServerProxy.getRestrictionValue(restrictions, key);
        if (valueAsString == null) {
            return null;
        }
        return Integer.parseInt(valueAsString);
    }

    @Nullable
    private static String getRestrictionValue(List<XmlaRestriction> restrictions, String key) {
        String value = null;
        for (XmlaRestriction restriction : restrictions) {
            String restrictionName = restriction.getName();
            if (!restrictionName.equals(key)) continue;
            value = restriction.getValue();
        }
        return value;
    }

    private static <T extends CdAbstractBitmapEnum> T getOptionalBitMap(List<XmlaRestriction> restrictions, String key, T defaultValue) throws XmlaProxyException {
        return XmlaServerProxy.getBitMap(restrictions, key, defaultValue, false);
    }

    private static <T extends CdAbstractBitmapEnum> T getBitMap(List<XmlaRestriction> restrictions, String key, T defaultValue, boolean mandatory) throws XmlaProxyException {
        String value = XmlaServerProxy.getRestrictionValue(restrictions, key);
        if (mandatory && value == null) {
            throw new XmlaServerProxyException("expected value [" + key + "] in restrictions [" + String.valueOf(restrictions) + "]");
        }
        return (T)(value == null ? defaultValue : defaultValue.newInstance(Integer.parseInt(value)));
    }

    private static String getProviderVersion() {
        return PROVIDER_VERSION;
    }

    private static String getServerName() {
        return CdNetworkUtils.getHostname();
    }

    private static OlapSchema getExistingCatalogReadMode(XmlaQueryContext context, List<XmlaProperty> properties) throws XmlaProxyException {
        return XmlaServerProxy.getExistingCatalog(IcCubeSchemaAccessLockMode.READ, context, properties);
    }

    private static OlapSchema getExistingCatalog(IcCubeSchemaAccessLockMode mode, XmlaQueryContext context, List<XmlaProperty> properties) throws XmlaProxyException {
        String schemaName = XmlaServerProxy.getExistingPropertyValue(properties, "Catalog");
        OlapSchema schema = context.getSchema(mode, properties, schemaName);
        if (schema == null) {
            throw new XmlaServerProxyException("missing catalog [" + schemaName + "]!");
        }
        return schema;
    }

    public void onStarted(XmlaQueryContext context) {
    }

    public void onShutdown() {
    }

    public int getXmlaSessionCount() {
        return this.xmlaSessionManager.getSessionCount();
    }

    public XmlaQuerySessionContext createSession(@Nullable HttpSession httpSession, String sessionId) {
        return this.xmlaSessionManager.createSession(httpSession, sessionId);
    }

    @Nullable
    public XmlaQuerySessionContext getSession(@Nullable String sessionId) {
        return this.xmlaSessionManager.getSession(sessionId);
    }

    @Nullable
    public XmlaQuerySessionContext closeSession(@Nullable String sessionId) {
        return this.xmlaSessionManager.closeSession(sessionId);
    }

    public XmlaQuerySessionContext createSession(String uuid, XmlaQueryContext context, List<XmlaProperty> properties) {
        return this.xmlaSessionManager.createSession(null, uuid);
    }

    public void closeSession(XmlaQueryContext context, String sessionId) {
        this.xmlaSessionManager.closeSession(sessionId);
    }

    public List<IXmlaDiscoverInstance> getDiscoverInstances(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        ArrayList<IXmlaDiscoverInstance> instances = new ArrayList<IXmlaDiscoverInstance>();
        return instances;
    }

    public List<IXmlaDiscoverDataSources> getDiscoverDataSources(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        CdXmlaCaller caller;
        CdXmlaCaller cdXmlaCaller = caller = context != null ? context.getXmlaCaller() : CdXmlaCaller.ic3;
        if (CdXmlaCaller.ic3.equals((Object)caller)) {
            ArrayList<IXmlaDiscoverDataSources> datasources = new ArrayList<IXmlaDiscoverDataSources>();
            datasources.add((IXmlaDiscoverDataSources)new XmlaDiscoverDataSourcesBean(PROVIDER_NAME, "", "", "", PROVIDER_NAME, "MDP", "Unauthenticated"));
            return datasources;
        }
        ArrayList<IXmlaDiscoverDataSources> datasources = new ArrayList<IXmlaDiscoverDataSources>();
        datasources.add((IXmlaDiscoverDataSources)new XmlaDiscoverDataSourcesBean(PROVIDER_NAME, "", "", "", PROVIDER_NAME, "MDP", "Unauthenticated"));
        return datasources;
    }

    public List<IXmlaDBSchemaCatalogs> getDiscoverDBSchemaCatalogs(XmlaQueryContext xmlaRequestContext, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        ArrayList<IXmlaDBSchemaCatalogs> catalogs = new ArrayList<IXmlaDBSchemaCatalogs>();
        OlapEngineRequestContext olapEngineRequestContext = xmlaRequestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapRuntimeContext rContext = olapEngineRequestContext.asRuntimeContext();
        OlapRoleApplicationPermissions applicationPermissions = olapEngineRequestContext.getApplicationPermissions();
        IOlapSchemasPermission schemasPermissions = olapEngineRequestContext.getSchemasPermissions();
        for (String schema : olapEngine.getAllAuthorizedSchemaNames(rContext, applicationPermissions, schemasPermissions)) {
            catalogs.add((IXmlaDBSchemaCatalogs)new XmlaDBSchemaCatalogsBean(schema));
        }
        return catalogs;
    }

    public List<IXmlaDBSchemaTables> getDiscoverDBSchemaTables(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        return Collections.emptyList();
    }

    public List<IXmlaDiscoverProperties> getDiscoverProperties(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        ArrayList<IXmlaDiscoverProperties> xproperties = new ArrayList<IXmlaDiscoverProperties>();
        List<XmlaRestriction> propRestrictions = XmlaServerProxy.getRestrictions(restrictions, "PropertyName");
        Iterable<OlapProperty> olapEngineProperties = this.getOlapEngineProperties(context);
        if (propRestrictions == null || propRestrictions.isEmpty()) {
            this.discoverAllProperties(context, xproperties, properties, olapEngineProperties);
        } else {
            for (XmlaRestriction restriction : propRestrictions) {
                this.discoverProperty(context, xproperties, properties, olapEngineProperties, restriction);
            }
        }
        return xproperties;
    }

    private void discoverProperty(XmlaQueryContext context, List<IXmlaDiscoverProperties> xproperties, List<XmlaProperty> properties, Iterable<OlapProperty> olapEngineProperties, XmlaRestriction restriction) {
        CdXmlaCaller caller = context.getXmlaCaller();
        String requestedPropertyName = restriction.getValue();
        Map<String, IXmlaDiscoverProperties> XMLA_PROPERTIES = XmlaServerProxy.XMLA_PROPERTIES(caller);
        IXmlaDiscoverProperties value = XMLA_PROPERTIES.get(requestedPropertyName);
        if (value != null) {
            xproperties.add(value);
        } else if (CdXmlaCaller.ic3.equals((Object)caller)) {
            for (OlapProperty olapProperty : olapEngineProperties) {
                if (!olapProperty.getDescription().getName().equals(requestedPropertyName)) continue;
                xproperties.add((IXmlaDiscoverProperties)XmlaServerProxy.createXmlaProperty(olapProperty));
                break;
            }
        } else if ("Catalog".equals(requestedPropertyName)) {
            String catalogName = XmlaServerProxy.getPropertyValue(properties, "Catalog");
            if (catalogName == null) {
                String catalog = this.getFirstAuthorizedSchemaName(context);
                if (catalog != null) {
                    xproperties.add((IXmlaDiscoverProperties)XmlaServerProxy.createCatalogXmlaProperty(catalog));
                }
            } else {
                xproperties.add((IXmlaDiscoverProperties)XmlaServerProxy.createCatalogXmlaProperty(catalogName));
            }
        }
    }

    private void discoverAllProperties(XmlaQueryContext context, List<IXmlaDiscoverProperties> xproperties, List<XmlaProperty> properties, Iterable<OlapProperty> olapEngineProperties) {
        String catalogName;
        CdXmlaCaller caller = context.getXmlaCaller();
        xproperties.addAll(XmlaServerProxy.XMLA_PROPERTIES(caller).values());
        if (CdXmlaCaller.ic3.equals((Object)caller)) {
            for (OlapProperty olapProperty : olapEngineProperties) {
                xproperties.add((IXmlaDiscoverProperties)XmlaServerProxy.createXmlaProperty(olapProperty));
            }
        }
        if ((catalogName = XmlaServerProxy.getPropertyValue(properties, "Catalog")) == null) {
            String catalog = this.getFirstAuthorizedSchemaName(context);
            if (catalog != null) {
                xproperties.add((IXmlaDiscoverProperties)XmlaServerProxy.createCatalogXmlaProperty(catalog));
            }
        } else {
            xproperties.add((IXmlaDiscoverProperties)XmlaServerProxy.createCatalogXmlaProperty(catalogName));
        }
    }

    private Iterable<OlapProperty> getOlapEngineProperties(XmlaQueryContext xmlaRequestContext) {
        OlapEngineRequestContext olapEngineRequestContext = xmlaRequestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapProperties props = olapEngine.getProperties();
        return props.getValidatedProperties();
    }

    public List<IXmlaDiscoverSchemaRowSet> getDiscoverSchemaRowSet(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        CdXmlaCaller caller = context != null ? context.getXmlaCaller() : CdXmlaCaller.ic3;
        ArrayList<IXmlaDiscoverSchemaRowSet> list = new ArrayList<IXmlaDiscoverSchemaRowSet>();
        String schemaNameRestriction = XmlaServerProxy.getRestrictionValue(restrictions, "SchemaName");
        List<Class<? extends IXmlaDiscover>> all = XmlaDiscoverRowSetFactory.getXmlSupportedClasses();
        for (Class<? extends IXmlaDiscover> clazz : all) {
            XmlaAnDiscoverType annotation = (XmlaAnDiscoverType)CdClassUtils.getExistingAnnotation(clazz, XmlaAnDiscoverType.class);
            if ("DISCOVER_XML_METADATA".equals(annotation.name()) || "DISCOVER_CSDL_METADATA".equals(annotation.name()) && !CdXmlaCaller.PowerBI.equals((Object)caller) || schemaNameRestriction != null && !schemaNameRestriction.equals(annotation.name())) continue;
            ArrayList<XmlaHChapterElement> schemaRestrictions = new ArrayList<XmlaHChapterElement>();
            XmlaDiscoverRowSet rowSet = XmlaDiscoverRowSetFactory.getExisting(annotation.name());
            for (IXmlaDiscoverRowColumn iXmlaDiscoverRowColumn : rowSet.getList()) {
                XmlaHChapterElement chapter = iXmlaDiscoverRowColumn.getRestrictionChapter();
                if (chapter == null) continue;
                schemaRestrictions.add(chapter);
            }
            String[] restrictionOrder = annotation.restrictionOrder();
            if (restrictionOrder != null && restrictionOrder.length > 0) {
                List<String> list2 = Arrays.asList(restrictionOrder);
                schemaRestrictions.sort((o1, o2) -> {
                    int pos1 = schemaRestrictionsOrder.indexOf(o1.getName());
                    int pos2 = schemaRestrictionsOrder.indexOf(o2.getName());
                    return Integer.compare(pos1, pos2);
                });
            }
            list.add((IXmlaDiscoverSchemaRowSet)new XmlaDiscoverSchemaRowSetBean(annotation.name(), annotation.guid(), schemaRestrictions));
        }
        list.sort(Comparator.comparing(IXmlaDiscoverSchemaRowSet::getSchemaName));
        return list;
    }

    public List<IXmlaMDSchemaProperty> getMDSchemaProperty(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        OlapSchema catalog;
        ArrayList<IXmlaMDSchemaProperty> sproperties = new ArrayList<IXmlaMDSchemaProperty>();
        XmlaPropertyType propertyType = XmlaServerProxy.getOptionalBitMap(restrictions, "PROPERTY_TYPE", XmlaPropertyType.MDPROP_ALL);
        if (propertyType.has((CdAbstractBitmapEnum)XmlaPropertyType.MDPROP_CELL)) {
            catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
            this.doGetMdSchemaCellProperty(context, catalog, sproperties, restrictions);
        }
        if (propertyType.has((CdAbstractBitmapEnum)XmlaPropertyType.MDPROP_MEMBER)) {
            catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
            this.doGetMdSchemaMemberProperty(context, catalog, sproperties, restrictions);
        }
        if (propertyType.has((CdAbstractBitmapEnum)XmlaPropertyType.MDPROP_SYSTEM)) {
            // empty if block
        }
        if (propertyType.has((CdAbstractBitmapEnum)XmlaPropertyType.MDPROP_BLOB)) {
            // empty if block
        }
        return sproperties;
    }

    private void doGetMdSchemaCellProperty(XmlaQueryContext context, OlapSchema catalog, List<IXmlaMDSchemaProperty> properties, List<XmlaRestriction> restrictions) throws XmlaProxyException {
        OlapRequestNamesContext schemaNameContext = context.getNameContext();
        XmlaCellPropertyManager cellPropertyManager = new XmlaCellPropertyManager();
        String cubeName = XmlaServerProxy.getRestrictionValue(restrictions, "CUBE_NAME");
        if (cubeName != null) {
            IOlapSchemaPermission permissions = XmlaServerProxy.getSchemaPermissions(context, catalog);
            List schemaCubes = catalog.getCubes(permissions);
            for (OlapCube cube : schemaCubes) {
                if (!cube.getName((OlapNameContext)schemaNameContext).equals(cubeName)) continue;
                OlapNameContext nameContext = permissions.getDimensionsPermissions(cube).getNamingContext(schemaNameContext);
                OlapMeasuresDimension measures = cube.getMeasuresDimension();
                properties.addAll(cellPropertyManager.getAllProperties(catalog.getName(), cubeName, measures.getUniqueName(nameContext), measures.getLevel().getHierarchy().getUniqueName(nameContext), measures.getLevel().getUniqueName(nameContext)));
                break;
            }
        } else {
            properties.addAll(cellPropertyManager.getAllProperties(catalog.getName(), cubeName, null, null, null));
        }
    }

    private void doGetMdSchemaMemberProperty(XmlaQueryContext context, OlapSchema catalog, final List<IXmlaMDSchemaProperty> properties, List<XmlaRestriction> restrictions) throws XmlaProxyException {
        final OlapRequestNamesContext schemaNameContext = context.getNameContext();
        final String hierarchyUniqueName = XmlaServerProxy.getRestrictionValue(restrictions, "HIERARCHY_UNIQUE_NAME");
        final String levelUniqueName = XmlaServerProxy.getRestrictionValue(restrictions, "LEVEL_UNIQUE_NAME");
        final String propertyName = XmlaServerProxy.getRestrictionValue(restrictions, "PROPERTY_NAME");
        if (propertyName != null && !propertyName.equals("MEMBER_VALUE")) {
            OlapLoggers.XMLA_REQUEST.warn((Object)("MDSCHEMA_PROPERTIES : no member property returned for [hierarchy:" + hierarchyUniqueName + "] [level:" + levelUniqueName + "] [property:" + propertyName + "]"));
            return;
        }
        final IOlapSchemaPermission schemaPermissions = XmlaServerProxy.getSchemaPermissions(context, catalog);
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) throws XmlaProxyException {
                IOlapDimensionsPermission dimensionsPermission = schemaPermissions.getDimensionsPermissions(cube);
                OlapNameContext nameContext = dimensionsPermission.getNamingContext(schemaNameContext);
                for (OlapDimension dimension : this.this$0.getCubeDimensions(cube, dimensionsPermission)) {
                    List allHierarchies = dimension.getHierarchies(dimensionsPermission);
                    for (OlapHierarchy hierarchy : allHierarchies) {
                        if (hierarchyUniqueName != null && hierarchyUniqueName.equals(hierarchy.getUniqueName(nameContext))) {
                            this.this$0.doGetMdSchemaMemberProperty(nameContext, dimensionsPermission, properties, catalog, cube, hierarchy, levelUniqueName, propertyName);
                            continue;
                        }
                        this.this$0.doGetMdSchemaMemberProperty(nameContext, dimensionsPermission, properties, catalog, cube, hierarchy, levelUniqueName, propertyName);
                    }
                }
            }
        });
    }

    private void doGetMdSchemaMemberProperty(OlapNameContext nameContext, IOlapDimensionsPermission permission, List<IXmlaMDSchemaProperty> properties, OlapSchema schema, OlapCube cube, OlapHierarchy hierarchy, @Nullable String levelUniqueName, @Nullable String propertyName) throws XmlaProxyException {
        IOlapHierarchyPermission hierarchyPermissions = permission.getDimensionPermissions(hierarchy.getDimension()).getHierarchyPermission(hierarchy);
        for (OlapLevel level : hierarchy.getLevels(hierarchyPermissions)) {
            if (levelUniqueName != null && !levelUniqueName.equals(level.getUniqueName(nameContext))) continue;
            if (propertyName != null) {
                if (!propertyName.equals("MEMBER_VALUE")) {
                    return;
                }
                if (!hierarchy.isExcelTimeLine()) {
                    return;
                }
                properties.add((IXmlaMDSchemaProperty)new XmlaMDSchemaPropertyBean(schema.getName(), cube.getName(nameContext), level.getDimension().getUniqueName(nameContext), level.getHierarchy().getUniqueName(nameContext), level.getUniqueName(nameContext), XmlaPropertyType.MDPROP_MEMBER, "MEMBER_VALUE", CdXmlaSchemaType.DBTYPE_DATE, new XmlaPropertyOrigin(6), level.getHierarchy().getName(nameContext), XmlaPropertyCardinality.MANY, Boolean.valueOf(true)));
                continue;
            }
            List levelProperties = level.getMemberProperties(permission.getMemberFilter());
            for (OlapUserDefinedMemberProperty levelProperty : levelProperties) {
                properties.add((IXmlaMDSchemaProperty)new XmlaMDSchemaPropertyBean(schema.getName(), cube.getName(nameContext), levelProperty.getLevel().getDimension().getUniqueName(nameContext), levelProperty.getLevel().getHierarchy().getUniqueName(nameContext), levelProperty.getLevel().getUniqueName(nameContext), XmlaPropertyType.MDPROP_MEMBER, levelProperty.getName(), levelProperty.getXmlaType(), XmlaPropertyOrigin.MD_USER_DEFINED, levelProperty.getName(), XmlaPropertyCardinality.MANY, Boolean.valueOf(true)));
            }
        }
    }

    public List<IXmlaMDSchemaCube> getMDSchemaCube(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        OlapRequestNamesContext schemaNameContext = context.getNameContext();
        ArrayList<IXmlaMDSchemaCube> cubes = new ArrayList<IXmlaMDSchemaCube>();
        String cubeName = XmlaServerProxy.getRestrictionValue(restrictions, "CUBE_NAME");
        if (cubeName == null) {
            cubeName = XmlaServerProxy.getPropertyValue(properties, "Cube");
        }
        XmlaCubeSource cubeSource = XmlaServerProxy.getOptionalBitMap(restrictions, "CUBE_SOURCE", XmlaCubeSource.CUBE);
        String catalogName = XmlaServerProxy.getPropertyValue(properties, "Catalog");
        if (catalogName == null) {
            cubes.add((IXmlaMDSchemaCube)new XmlaMDSchemaCubeBean("icCube Unspecified Cube", "icCube Unspecified Cube", XmlaCubeType.CUBE, "icCube Unspecified Cube", "icCube Unspecified Cube", false, false, false, false, XmlaCubeSource.CUBE, null));
            return cubes;
        }
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        IOlapSchemaPermission schemaPermissions = XmlaServerProxy.getSchemaPermissions(context, catalog);
        List schemaCubes = catalog.getCubes(schemaPermissions);
        for (OlapCube cube : schemaCubes) {
            String name = cube.getName((OlapNameContext)schemaNameContext);
            IOlapDimensionsPermission dimensionsPermission = schemaPermissions.getDimensionsPermissions(cube);
            OlapNameContext nameContext = dimensionsPermission.getNamingContext(schemaNameContext);
            if (cubeName != null) {
                if (!cubeName.equals(name)) continue;
                this.addCubeDimension(nameContext, context, catalog, cubes, cube, cubeSource);
                continue;
            }
            this.addCubeDimension(nameContext, context, catalog, cubes, cube, cubeSource);
        }
        return cubes;
    }

    private void addCubeDimension(OlapNameContext nameContext, XmlaQueryContext context, OlapSchema catalog, List<IXmlaMDSchemaCube> cubes, OlapCube cube, XmlaCubeSource cubeSource) {
        if (cubeSource.has((CdAbstractBitmapEnum)XmlaCubeSource.DIMENSION)) {
            IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
            for (OlapDimension dimension : this.getCubeDimensions(cube, dimensionsPermission)) {
                cubes.add((IXmlaMDSchemaCube)new XmlaMDSchemaCubeBean(catalog.getName(), "$" + dimension.getName(nameContext), XmlaCubeType.DIMENSION, "$" + dimension.getName(nameContext), "", false, false, false, false, XmlaCubeSource.DIMENSION, null));
            }
        }
        if (cubeSource.has((CdAbstractBitmapEnum)XmlaCubeSource.CUBE)) {
            cubes.add((IXmlaMDSchemaCube)new XmlaMDSchemaCubeBean(catalog.getName(), cube.getName(nameContext), XmlaCubeType.CUBE, cube.getCaption(context.getLocale(), nameContext), cube.getDescription(), true, false, false, false, XmlaCubeSource.CUBE, cube.getLastDataUpdatedTime()));
        }
    }

    public List<IXmlaMDSchemaDimension> getMDSchemaDimension(final XmlaQueryContext context, List<XmlaRestriction> restrictions, final List<XmlaProperty> properties) throws XmlaProxyException {
        final ArrayList<IXmlaMDSchemaDimension> dimensions = new ArrayList<IXmlaMDSchemaDimension>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        final String restriction = XmlaServerProxy.getRestrictionValue(restrictions, "DIMENSION_UNIQUE_NAME");
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) throws XmlaProxyException {
                String cubeName = cube.getName((OlapNameContext)context.getNameContext());
                IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
                OlapNameContext nameContext = dimensionsPermission.getNamingContext(context.getNameContext());
                if (restriction != null) {
                    OlapDimension dimension = this.this$0.lookupDimension(context, properties, cubeName, restriction);
                    this.this$0.addDimension(context.getLocale(), nameContext, dimensionsPermission, catalog, dimensions, cubeName, cube, dimension);
                } else {
                    for (OlapDimension dimension : this.this$0.getCubeDimensions(cube, dimensionsPermission)) {
                        this.this$0.addDimension(context.getLocale(), nameContext, dimensionsPermission, catalog, dimensions, cubeName, cube, dimension);
                    }
                }
            }
        });
        return dimensions;
    }

    private void addDimension(Locale locale, OlapNameContext nameContext, IOlapDimensionsPermission dimensionsPermission, OlapSchema catalog, List<IXmlaMDSchemaDimension> dimensions, String cubeName, OlapCube cube, OlapDimension dimension) {
        String caption = dimension.getCaption(locale, nameContext);
        XmlaDimensionType type = this.getDimensionType(dimension);
        dimensions.add((IXmlaMDSchemaDimension)new XmlaMDSchemaDimensionBean(catalog.getName(), cubeName, dimension.getName(nameContext), dimension.getUniqueName(nameContext), caption, cube.getDimensionOrdinal(dimension), this.getXmlaCardinality(dimension, dimensionsPermission.getMemberFilter()), this.getXmlaDefaultHierarchy(nameContext, dimension, dimensionsPermission).getUniqueName(nameContext), type));
    }

    private XmlaDimensionType getDimensionType(OlapDimension dimension) {
        if (dimension.isMeasures()) {
            return XmlaDimensionType.MD_DIMTYPE_MEASURE;
        }
        if (dimension.isTime()) {
            return XmlaDimensionType.MD_DIMTYPE_TIME;
        }
        return XmlaDimensionType.MD_DIMTYPE_OTHER;
    }

    private int getXmlaCardinality(OlapDimension dimension, OlapMemberFilter filter) {
        return this.getXmlaCardinality(dimension.getBaseHierarchy(), filter);
    }

    private int getXmlaCardinality(OlapHierarchy hierarchy, OlapMemberFilter filter) {
        int count = 0;
        for (OlapLevel level : hierarchy.getLevels()) {
            count += this.getXmlaCardinality(level, filter);
        }
        return count;
    }

    private int getXmlaCardinality(OlapLevel level, OlapMemberFilter tupleFilter) {
        return level.getXmlaCardinality(tupleFilter);
    }

    private OlapHierarchy getXmlaDefaultHierarchy(OlapNameContext schemaNameContext, OlapDimension dimension, IOlapDimensionsPermission permissions) {
        List myHierarchies = dimension.getHierarchies(permissions);
        if (myHierarchies.isEmpty()) {
            throw new CdRuntimeException("No hierarchy available in dimension [" + dimension.getUniqueName(schemaNameContext) + "]");
        }
        return (OlapHierarchy)myHierarchies.get(0);
    }

    public List<IXmlaMDSchemaHierarchy> getMDSchemaHierarchy(final XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        XmlaPropertyVisibility visibility = XmlaServerProxy.getOptionalBitMap(restrictions, "HIERARCHY_VISIBILITY", XmlaPropertyVisibility.VISIBLE);
        final boolean visible = visibility.has((CdAbstractBitmapEnum)XmlaPropertyVisibility.VISIBLE);
        final ArrayList<IXmlaMDSchemaHierarchy> hierarchies = new ArrayList<IXmlaMDSchemaHierarchy>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) {
                IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
                OlapNameContext nameContext = dimensionsPermission.getNamingContext(context.getNameContext());
                for (OlapDimension dimension : this.this$0.getCubeDimensions(cube, dimensionsPermission)) {
                    IOlapDimensionPermission perms = dimensionsPermission.getDimensionPermissions(dimension);
                    for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                        if ((!visible || !perms.isHierarchyAuthorized(hierarchy)) && (visible || !perms.isHierarchyInvisible(hierarchy))) continue;
                        this.this$0.addHierarchy(context, nameContext, dimensionsPermission, catalog, hierarchies, cube, hierarchy, visible);
                    }
                }
            }
        });
        return hierarchies;
    }

    private void addHierarchy(XmlaQueryContext context, OlapNameContext nameContext, IOlapDimensionsPermission permissions, OlapSchema catalog, List<IXmlaMDSchemaHierarchy> hierarchies, OlapCube cube, OlapHierarchy hierarchy, boolean isVisible) {
        IOlapDimensionsPermission permissionsWithoutPerspective = this.getDimensionPermissionsWithoutPerspective(context, catalog, cube);
        OlapMember olapAllMember = hierarchy.getAllMember();
        String allMember = olapAllMember == null ? null : olapAllMember.getUniqueName(nameContext);
        OlapDimension dimension = hierarchy.getDimension();
        int cardinality = this.getXmlaCardinality(hierarchy, permissions.getMemberFilter());
        OlapMember defaultMember = hierarchy.getNullableDefaultMember(permissions.getMemberFilter());
        String defaultMemberName = defaultMember != null ? defaultMember.getUniqueName(nameContext) : null;
        int ordinal = this.getXmlaOrdinal(dimension, permissionsWithoutPerspective, hierarchy);
        String caption = hierarchy.getCaption(context.getLocale(), nameContext);
        XmlaDimensionType type = this.getDimensionType(hierarchy.getDimension());
        boolean excelTimeLine = hierarchy.isExcelTimeLine();
        boolean excelTimeLineVisible = hierarchy.isExcelTimeLineVisible();
        hierarchies.add((IXmlaMDSchemaHierarchy)new XmlaMDSchemaHierarchyBean(catalog.getName(), cube.getName(nameContext), dimension.getUniqueName(nameContext), hierarchy.getName(nameContext), hierarchy.getUniqueName(nameContext), caption, cardinality, defaultMemberName, allMember, ordinal, isVisible, type, excelTimeLine, excelTimeLineVisible, XmlaServerProxy.coalesceNull(hierarchy.getFolderName(), "")));
    }

    private int getXmlaOrdinal(OlapDimension dimension, IOlapDimensionsPermission permissions, OlapHierarchy hierarchy) {
        List myHierarchies = dimension.getHierarchies(permissions);
        int ordinal = 0;
        for (OlapHierarchy myHierarchy : myHierarchies) {
            if (myHierarchy == hierarchy) {
                return ordinal;
            }
            ++ordinal;
        }
        throw new CdProgrammingException("internal error : unable to find hierarchy [" + String.valueOf(hierarchy) + "] in dimension");
    }

    public List<IXmlaMDSchemaLevel> getMDSchemaLevel(final XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        XmlaPropertyVisibility visibility = XmlaServerProxy.getOptionalBitMap(restrictions, "LEVEL_VISIBILITY", XmlaPropertyVisibility.VISIBLE);
        final boolean visible = visibility.has((CdAbstractBitmapEnum)XmlaPropertyVisibility.VISIBLE);
        final ArrayList<IXmlaMDSchemaLevel> levels = new ArrayList<IXmlaMDSchemaLevel>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) throws XmlaProxyException {
                IOlapDimensionsPermission permissions = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
                OlapNameContext nameContext = permissions.getNamingContext(context.getNameContext());
                for (OlapDimension dimension : this.this$0.getCubeDimensions(cube, permissions)) {
                    IOlapDimensionPermission dimPermissions = permissions.getDimensionPermissions(dimension);
                    List allHierarchies = dimension.getHierarchies(dimPermissions);
                    for (OlapHierarchy hierarchy : allHierarchies) {
                        boolean excelTimeLine = hierarchy.isExcelTimeLine();
                        boolean excelTimeLineVisible = hierarchy.isExcelTimeLineVisible();
                        IOlapHierarchyPermission perms = dimPermissions.getHierarchyPermission(hierarchy);
                        for (OlapLevel level : hierarchy.getLevels()) {
                            if ((!visible || !perms.isLevelAuthorized(level)) && (visible || !perms.isLevelInvisible(level))) continue;
                            String caption = level.getCaption(context.getLocale(), nameContext);
                            levels.add(new XmlaMDSchemaLevelBean(catalog.getName(), cube.getName(nameContext), dimension.getUniqueName(nameContext), hierarchy.getUniqueName(nameContext), level.getName(nameContext), level.getUniqueName(nameContext), caption, this.this$0.getXmlaCardinality(level, permissions.getMemberFilter()), level.getLevelNumber(), visible, this.this$0.asXmlType(level), excelTimeLine, excelTimeLineVisible));
                        }
                    }
                }
            }
        });
        return levels;
    }

    private XmlaLevelType asXmlType(OlapLevel level) {
        if (level.isAll()) {
            return XmlaLevelType.MDLEVEL_TYPE_ALL;
        }
        OlapLevelType levelType = level.getLevelType();
        if (levelType == null) {
            return XmlaLevelType.MDLEVEL_TYPE_REGULAR;
        }
        switch (levelType) {
            case YEAR: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_YEARS;
            }
            case HALF_YEAR: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_HALF_YEAR;
            }
            case QUARTER: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_QUARTERS;
            }
            case MONTH: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_MONTHS;
            }
            case WEEK: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_WEEKS;
            }
            case DAY: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_DAYS;
            }
            case HOUR: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_HOURS;
            }
            case MINUTE: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_MINUTES;
            }
            case SECOND: {
                return XmlaLevelType.MDLEVEL_TYPE_TIME_SECONDS;
            }
        }
        return XmlaLevelType.MDLEVEL_TYPE_TIME_UNDEFINED;
    }

    public List<IXmlaMDSchemaMeasure> getMDSchemaMeasure(final XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        XmlaPropertyVisibility visibility = XmlaServerProxy.getOptionalBitMap(restrictions, "MEASURE_VISIBILITY", XmlaPropertyVisibility.VISIBLE);
        final boolean visible = visibility.has((CdAbstractBitmapEnum)XmlaPropertyVisibility.VISIBLE);
        final ArrayList<IXmlaMDSchemaMeasure> measures = new ArrayList<IXmlaMDSchemaMeasure>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) throws XmlaProxyException {
                IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
                OlapNameContext nameContext = dimensionsPermission.getNamingContext(context.getNameContext());
                String cubeName = cube.getName(nameContext);
                OlapMemberFilter visibleMemberFilter = this.this$0.getSchemaPermissionsMemberFilter(context, catalog, cube);
                OlapMemberFilter invisibleMemberFilter = this.this$0.getSchemaPermissionsInvisibleMemberFilter(context, catalog, cube);
                OlapMeasuresDimension measure = cube.getMeasuresDimension();
                for (OlapMeasureMember measureMember : measure.getMeasureMembers(null)) {
                    if ((!visible || !OlapMemberFilterHelper.isAccepting((OlapMemberFilter)visibleMemberFilter, (OlapMember)measureMember)) && (visible || invisibleMemberFilter == null || !invisibleMemberFilter.isAccepting((OlapMember)measureMember))) continue;
                    measures.add(new XmlaMDSchemaMeasureBean(catalog.getName(), cubeName, measureMember.getName(nameContext), measureMember.getUniqueName(nameContext), measureMember.getCaption(context.getLocale(), nameContext), XmlaServerProxy.coalesceNull(measureMember.getMeasureGroupName(), ""), XmlaMeasureAggregator.MDMEASURE_AGGR_SUM, null, visible, XmlaServerProxy.coalesceNull(this.this$0.fixDisplayFolder(context, measureMember.getDisplayFolder(context.getLocale(), nameContext)), "")));
                }
                List<OlapMember> cmembers = this.this$0.getCalcMembers(context, cube);
                for (OlapMember cmember : cmembers) {
                    if (!cmember.isMeasure() || (!visible || !cmember.isVisible() || !OlapMemberFilterHelper.isAccepting((OlapMemberFilter)visibleMemberFilter, (OlapMember)cmember)) && (visible || cmember.isVisible())) continue;
                    measures.add(new XmlaMDSchemaMeasureBean(catalog.getName(), cubeName, cmember.getName(nameContext), cmember.getUniqueName(nameContext), cmember.getCaption(context.getLocale(), nameContext), XmlaServerProxy.coalesceNull(cmember.getAssociatedMeasureGroup(), ""), XmlaMeasureAggregator.MDMEASURE_AGGR_CALCULATED, null, cmember.isVisible(), XmlaServerProxy.coalesceNull(this.this$0.fixDisplayFolder(context, cmember.getDisplayFolder(context.getLocale(), nameContext)), "")));
                }
            }
        });
        return measures;
    }

    public List<IXmlaDiscoverLiteral> getLiteral(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        ArrayList<IXmlaDiscoverLiteral> list = new ArrayList<IXmlaDiscoverLiteral>();
        Collections.addAll(list, XmlaLiteral.values());
        return list;
    }

    public List<IXmlaMDSchemaMember> getMDSchemaMember(final XmlaQueryContext context, final List<XmlaRestriction> restrictions, final List<XmlaProperty> properties) throws XmlaProxyException {
        final ArrayList<IXmlaMDSchemaMember> outMembers = new ArrayList<IXmlaMDSchemaMember>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) throws XmlaProxyException {
                ArrayList<IXmlaMDSchemaMember> members = new ArrayList<IXmlaMDSchemaMember>();
                String cubeName = cube.getName((OlapNameContext)context.getNameContext());
                IOlapDimensionsPermission perms = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
                OlapNameContext nc = perms.getNamingContext(context.getNameContext());
                MemberPropertyHelper memberPropertyHelper = new MemberPropertyHelper(context.getLocale(), nc, perms, cubeName);
                OlapMemberFilter memberFilter = this.this$0.getSchemaPermissionsMemberFilter(context, catalog, cube);
                String memberUniqueName = XmlaServerProxy.getRestrictionValue(restrictions, "MEMBER_UNIQUE_NAME");
                String levelUniqueName = XmlaServerProxy.getRestrictionValue(restrictions, "LEVEL_UNIQUE_NAME");
                String hierarchyUniqueName = XmlaServerProxy.getRestrictionValue(restrictions, "HIERARCHY_UNIQUE_NAME");
                if (memberUniqueName != null) {
                    treeOp = XmlaServerProxy.getOptionalBitMap(restrictions, "TREE_OP", XmlaTreeOp.MDTREEOP_SELF);
                    this.this$0.populateMDSchemaMemberTreeOp(memberFilter, memberPropertyHelper, context, catalog, properties, (List<IXmlaMDSchemaMember>)members, cubeName, memberUniqueName, (XmlaTreeOp)treeOp);
                } else if (levelUniqueName != null) {
                    OlapMember member;
                    XmlaTreeOp xTreeOp;
                    treeOp = XmlaServerProxy.getRestrictionValue(restrictions, "TREE_OP");
                    if (treeOp != null && !XmlaTreeOp.MDTREEOP_SELF.equals((Object)(xTreeOp = XmlaServerProxy.getOptionalBitMap(restrictions, "TREE_OP", XmlaTreeOp.MDTREEOP_SELF)))) {
                        throw new XmlaServerProxyException("unsupported TREE_OP [" + (String)treeOp + "]");
                    }
                    OlapLevel level = (OlapLevel)this.this$0.executeMdxValueExpression(context, properties, cubeName, levelUniqueName);
                    OlapIterator lmembers = level.getMembers(memberFilter).getIterator(false);
                    lmembers.reset();
                    while ((member = (OlapMember)lmembers.next()) != null) {
                        this.this$0.addMember(memberPropertyHelper, context, catalog, members, cubeName, member);
                    }
                    this.this$0.addLevelCalcMembers(memberFilter, memberPropertyHelper, context, catalog, members, cubeName, level);
                } else if (hierarchyUniqueName != null) {
                    OlapHierarchy hierarchy = this.this$0.lookupHierarchy(context, catalog, properties, cubeName, hierarchyUniqueName);
                    if (hierarchy != null) {
                        IOlapHierarchyPermission hierarchyPermissions = this.this$0.getHierarchyPermissions(context, catalog, cube, hierarchy);
                        List levels = hierarchy.getLevels(hierarchyPermissions);
                        Integer levelNumber = XmlaServerProxy.getRestrictionValueAsInteger(restrictions, "LEVEL_NUMBER");
                        for (OlapLevel level : levels) {
                            OlapMember member;
                            if (levelNumber != null && !levelNumber.equals(level.getLevelNumber())) continue;
                            OlapIterator lmembers = level.getMembers(memberFilter).getIterator(false);
                            lmembers.reset();
                            while ((member = (OlapMember)lmembers.next()) != null) {
                                this.this$0.addMember(memberPropertyHelper, context, catalog, members, cubeName, member);
                            }
                        }
                        this.this$0.addHierarchyCalcMembers(memberFilter, memberPropertyHelper, context, catalog, members, cubeName, hierarchy, levelNumber);
                    }
                } else {
                    throw new XmlaServerProxyException("unknown or missing restriction [" + String.valueOf(restrictions) + "]");
                }
                XmlaMemberType memberType = XmlaServerProxy.getRestrictionValueAsEnum(restrictions, "MEMBER_TYPE", XmlaMemberType.class, null);
                List<IXmlaMDSchemaMember> filteredMembers = memberType != null ? this.this$0.filterMembers(members, memberType) : members;
                memberPropertyHelper.assertEvaluatedProperties(filteredMembers);
                Collections.sort(filteredMembers, XmlaMDSchemaMemberBean.RANK_COMPARATOR);
                outMembers.addAll(filteredMembers);
            }
        });
        return outMembers;
    }

    private List<IXmlaMDSchemaMember> filterMembers(List<IXmlaMDSchemaMember> members, XmlaMemberType memberType) {
        ArrayList<IXmlaMDSchemaMember> filteredMembers = new ArrayList<IXmlaMDSchemaMember>();
        for (IXmlaMDSchemaMember member : members) {
            if (!memberType.equals((Object)member.getMemberType())) continue;
            filteredMembers.add(member);
        }
        return filteredMembers;
    }

    private void populateMDSchemaMemberTreeOp(@Nullable OlapMemberFilter memberFilter, MemberPropertyHelper memberPropertyHelper, XmlaQueryContext context, OlapSchema catalog, List<XmlaProperty> properties, List<IXmlaMDSchemaMember> members, String cubeName, String memberUniqueName, XmlaTreeOp treeOp) throws XmlaProxyException {
        OlapMember member = this.lookupMember(context, catalog, properties, cubeName, memberUniqueName);
        if (member == null) {
            return;
        }
        if (treeOp.has((CdAbstractBitmapEnum)XmlaTreeOp.MDTREEOP_CHILDREN)) {
            OlapMember child;
            OlapIterator children = member.getChildren(null);
            children.reset();
            while ((child = (OlapMember)children.next()) != null) {
                if (!OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)child)) continue;
                this.addMember(memberPropertyHelper, context, catalog, members, cubeName, child);
            }
            this.addChildCalcMembers(memberFilter, memberPropertyHelper, context, catalog, members, cubeName, member);
        }
        if (treeOp.has((CdAbstractBitmapEnum)XmlaTreeOp.MDTREEOP_SIBLINGS)) {
            OlapMember sibling;
            OlapLevel mlevel = member.getLevel();
            OlapIterator siblings = mlevel.getMembers(null).getIterator(false);
            siblings.reset();
            while ((sibling = (OlapMember)siblings.next()) != null) {
                if (OlapMember.equal((OlapMember)sibling, (OlapMember)member) || !OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)sibling)) continue;
                this.addMember(memberPropertyHelper, context, catalog, members, cubeName, sibling);
            }
            this.addLevelCalcMembers(memberFilter, memberPropertyHelper, context, catalog, members, cubeName, mlevel);
        }
        if (treeOp.has((CdAbstractBitmapEnum)XmlaTreeOp.MDTREEOP_PARENT) && member.getParent() != null && OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)member)) {
            this.addMember(memberPropertyHelper, context, catalog, members, cubeName, member.getParent());
        }
        if (treeOp.has((CdAbstractBitmapEnum)XmlaTreeOp.MDTREEOP_SELF) && OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)member)) {
            this.addMember(memberPropertyHelper, context, catalog, members, cubeName, member);
        }
        if (treeOp.has((CdAbstractBitmapEnum)XmlaTreeOp.MDTREEOP_DESCENDANTS) || treeOp.has((CdAbstractBitmapEnum)XmlaTreeOp.MDTREEOP_ANCESTORS)) {
            throw new XmlaServerProxyException("unsupported TREE_OP [" + String.valueOf(treeOp) + "]");
        }
    }

    @Nullable
    private OlapMember lookupMember(XmlaQueryContext context, OlapSchema catalog, List<XmlaProperty> properties, String cubeName, String memberUniqueName) throws XmlaProxyException {
        block8: {
            try {
                OlapEntity entity = this.executeMdxValueExpression(context, properties, cubeName, memberUniqueName);
                if (entity instanceof OlapDimension) {
                    OlapDimension dimension = (OlapDimension)entity;
                    OlapCube cube = XmlaServerProxy.getCube(context, catalog, cubeName);
                    if (dimension instanceof OlapMeasuresDimension) {
                        OlapMemberFilter tupleFilter = this.getSchemaPermissionsMemberFilter(context, catalog, cube);
                        OlapMeasuresDimension measuresDimension = (OlapMeasuresDimension)dimension;
                        return measuresDimension.getDefaultMeasure(tupleFilter);
                    }
                    IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
                    if (dimension.isSingleHierarchy(dimensionsPermission)) {
                        return dimension.getSingleHierarchy(dimensionsPermission).getNonNullDefaultMember(dimensionsPermission.getMemberFilter());
                    }
                } else {
                    if (entity instanceof OlapHierarchy) {
                        OlapCube cube = XmlaServerProxy.getCube(context, catalog, cubeName);
                        OlapMemberFilter tupleFilter = this.getSchemaPermissionsMemberFilter(context, catalog, cube);
                        OlapHierarchy hierarchy = (OlapHierarchy)entity;
                        return hierarchy.getNonNullDefaultMember(tupleFilter);
                    }
                    if (entity instanceof OlapMember) {
                        return (OlapMember)entity;
                    }
                }
            }
            catch (OlapEvaluationException ex) {
                if (ex.isCausedBy((CdErrorCode)OlapErrorCode.UNKNOWN_ENTITY) || ex.isCausedBy((CdErrorCode)OlapErrorCode.UNKNOWN_DIMENSION_HIERARCHY) || ex.isCausedBy((CdErrorCode)OlapErrorCode.UNKNOWN_MEASURE)) break block8;
                throw ex;
            }
        }
        return null;
    }

    private void addHierarchyCalcMembers(@Nullable OlapMemberFilter memberFilter, MemberPropertyHelper memberPropertyHelper, XmlaQueryContext context, OlapSchema catalog, List<IXmlaMDSchemaMember> members, String cubeName, OlapHierarchy hierarchy, @Nullable Integer levelNumber) {
        OlapCube cube = XmlaServerProxy.getCube(context, catalog, cubeName);
        if (cube == null) {
            return;
        }
        List<OlapMember> cmembers = this.getCalcMembers(context, cube);
        for (OlapMember cmember : cmembers) {
            OlapLevel level;
            if (!cmember.getHierarchy().equals((Object)hierarchy) || levelNumber != null && !levelNumber.equals((level = cmember.getLevel()).getLevelNumber()) || !OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)cmember)) continue;
            this.addMember(memberPropertyHelper, context, catalog, members, cubeName, cmember);
        }
    }

    private void addLevelCalcMembers(@Nullable OlapMemberFilter memberFilter, MemberPropertyHelper memberPropertyHelper, XmlaQueryContext context, OlapSchema catalog, List<IXmlaMDSchemaMember> members, String cubeName, OlapLevel level) {
        OlapCube cube = XmlaServerProxy.getCube(context, catalog, cubeName);
        if (cube == null) {
            return;
        }
        List<OlapMember> cmembers = this.getCalcMembers(context, cube);
        for (OlapMember cmember : cmembers) {
            if (!cmember.getLevel().equals((Object)level) || !OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)cmember)) continue;
            this.addMember(memberPropertyHelper, context, catalog, members, cubeName, cmember);
        }
    }

    private void addChildCalcMembers(@Nullable OlapMemberFilter memberFilter, MemberPropertyHelper memberPropertyHelper, XmlaQueryContext context, OlapSchema catalog, List<IXmlaMDSchemaMember> members, String cubeName, OlapMember parent) {
        OlapCube cube = XmlaServerProxy.getCube(context, catalog, cubeName);
        if (cube == null) {
            return;
        }
        List<OlapMember> cmembers = this.getCalcMembers(context, cube);
        for (OlapMember cmember : cmembers) {
            if (!parent.equals((Object)cmember.getParent()) || !OlapMemberFilterHelper.isAccepting((OlapMemberFilter)memberFilter, (OlapMember)cmember)) continue;
            this.addMember(memberPropertyHelper, context, catalog, members, cubeName, cmember);
        }
    }

    @Nullable
    private OlapHierarchy lookupHierarchy(XmlaQueryContext context, OlapSchema catalog, List<XmlaProperty> properties, String cubeName, String uniqueName) throws XmlaProxyException {
        OlapEntity entity = this.executeMdxValueExpression(context, properties, cubeName, uniqueName);
        if (entity instanceof OlapDimension) {
            OlapDimension dimension = (OlapDimension)entity;
            if (dimension.isMeasures()) {
                return dimension.getMeasureHierarchy();
            }
            IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, XmlaServerProxy.getCube(context, catalog, cubeName));
            if (dimension.isSingleHierarchy(dimensionsPermission)) {
                return dimension.getSingleHierarchy(dimensionsPermission);
            }
            return null;
        }
        return (OlapHierarchy)entity;
    }

    private OlapDimension lookupDimension(XmlaQueryContext context, List<XmlaProperty> properties, String cubeName, String uniqueName) throws XmlaProxyException {
        OlapEntity entity = this.executeMdxValueExpression(context, properties, cubeName, uniqueName);
        return (OlapDimension)entity;
    }

    private void addMember(MemberPropertyHelper memberPropertyHelper, XmlaQueryContext context, OlapSchema catalog, List<IXmlaMDSchemaMember> members, String cubeName, OlapMember member) {
        String parentUName;
        IcCubeRequest.assertNotCancelled((String)"xmla-member");
        OlapCube cube = XmlaServerProxy.getCube(context, catalog, cubeName);
        IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
        OlapNameContext nameContext = dimensionsPermission.getNamingContext(context.getNameContext());
        Locale locale = context.getLocale();
        String dimUName = member.getDimension().getUniqueName(nameContext);
        String hierarchyUName = member.getHierarchy().getUniqueName(nameContext);
        String levelUName = member.getLevel().getUniqueName(nameContext);
        int levelNumber = member.getLevel().getLevelNumber();
        String memberName = member.getName(nameContext);
        String memberCaption = this.fixMemberCaption(locale, nameContext, dimensionsPermission, cubeName, member);
        String memberUName = member.getUniqueName(nameContext);
        int childrenCardinality = member.getXmlaChildrenCardinality(XmlaServerProxy.getDimensionsPermissions(context, catalog, cube).getMemberFilter());
        OlapMember parent = member.getParent();
        int parentLevel = parent != null ? parent.getLevel().getLevelNumber() : 0;
        String string = parentUName = parent != null ? parent.getUniqueName(nameContext) : null;
        XmlaMemberType memberType = member.isCalculated() ? XmlaMemberType.MDMEMBER_TYPE_FORMULA : (member.isAll() ? XmlaMemberType.MDMEMBER_TYPE_ALL : (member.isMeasure() ? XmlaMemberType.MDMEMBER_TYPE_MEASURE : XmlaMemberType.MDMEMBER_TYPE_REGULAR));
        OlapMemberKey memberKey = member.getKey();
        String memberKeyAsString = memberKey == null ? null : memberKey.asScalarEntity().asString();
        XmlaMDSchemaMemberProperties properties = memberPropertyHelper.evalProperties(dimensionsPermission.getMemberFilter(), member);
        members.add((IXmlaMDSchemaMember)new XmlaMDSchemaMemberBean(catalog.getName(), cubeName, dimUName, hierarchyUName, levelUName, levelNumber, memberName, memberCaption, memberUName, childrenCardinality, parentLevel, parentUName, memberKeyAsString, memberType, properties, (Comparable)member.getRank()));
    }

    private String fixMemberCaption(Locale locale, OlapNameContext nameContext, IOlapDimensionsPermission dimensionsPermission, String cubeName, OlapMember member) {
        OlapMemberPropertyEvalContext evalContext = new OlapMemberPropertyEvalContext(locale, nameContext, dimensionsPermission, cubeName);
        OlapScalarEntity caption = OlapIntrinsicMemberProperties.MEMBER_CAPTION.eval(evalContext, member);
        return caption.asString();
    }

    public List<IXmlaMDSchemaSet> getMDSchemaSet(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        ArrayList<IXmlaMDSchemaSet> items = new ArrayList<IXmlaMDSchemaSet>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        ArrayList<OlapSetDeclaration> sets = new ArrayList<OlapSetDeclaration>();
        IOlapSchemaPermission perms = this.getSchemaPermissionsWithoutPerspective(context, catalog);
        for (OlapSetDeclaration setDeclaration : catalog.getSetDeclarations()) {
            if (!perms.isSetAuthorized(setDeclaration.getSetName())) continue;
            sets.add(setDeclaration);
        }
        sets.addAll(context.getSessionSetDeclarations(catalog));
        String cubeName = XmlaServerProxy.getRestrictionValue(restrictions, "CUBE_NAME");
        String setName = XmlaServerProxy.getRestrictionValue(restrictions, "SET_NAME");
        for (OlapSetDeclaration set : sets) {
            String resolvedSetCubeName = this.resolveSetCubeName(context, catalog, set.getCubeName());
            if (resolvedSetCubeName != null && cubeName != null && !cubeName.equals(resolvedSetCubeName) || setName != null && !setName.equals(set.getSetName())) continue;
            OlapCube cube = null;
            if (cubeName != null && (cube = XmlaServerProxy.getCube(context, catalog, cubeName)) == null) continue;
            IOlapDimensionsPermission dimensionsPermission = XmlaServerProxy.getDimensionsPermissions(context, catalog, cube);
            final OlapNameContext nameContext = dimensionsPermission.getNamingContext(context.getNameContext());
            List<OlapHierarchy> hierarchies = this.getSetDimensionality(context, properties, catalog, set);
            boolean setIsNotForCube = false;
            if (cube != null) {
                for (OlapHierarchy hierarchy : hierarchies) {
                    if (cube.isOwnDimension(hierarchy.getDimension())) continue;
                    setIsNotForCube = true;
                    break;
                }
            }
            if (setIsNotForCube) continue;
            String setHierarchies = CdCollections.toString(hierarchies, (String)"", (String)",", (CdCollections.Stringfier)new CdCollections.Stringfier<OlapHierarchy>(){
                {
                    Objects.requireNonNull(this$0);
                }

                public String toString(OlapHierarchy hierarchy) {
                    return hierarchy.getUniqueName(nameContext);
                }
            });
            String caption = set.getSetCaption(context.getLocale(), catalog);
            items.add((IXmlaMDSchemaSet)new XmlaMDSchemaSetBean(catalog.getName(), resolvedSetCubeName == null ? cubeName : resolvedSetCubeName, set.getSetName(), set.isSessionScoped() ? XmlaSetScope.MDSET_SCOPE_SESSION : XmlaSetScope.MDSET_SCOPE_GLOBAL, null, set.getMdx(), setHierarchies, caption, this.fixDisplayFolder(context, set.getDisplayFolder()), set.isDynamicEvaluation() ? XmlaSetEvaluationContext.MDSET_RESOLUTION_DYNAMIC : XmlaSetEvaluationContext.MDSET_RESOLUTION_STATIC));
        }
        return items;
    }

    private List<OlapHierarchy> getSetDimensionality(XmlaQueryContext context, List<XmlaProperty> requestXmlaProperties, OlapSchema schema, OlapSetDeclaration set) {
        String setCubeName = set.getCubeName();
        Object setCube = setCubeName != null ? XmlaServerProxy.getCube(context, schema, setCubeName) : new OlapSchemaStaticSetFormulaEvaluationCube(schema);
        if (setCube == null) {
            throw new RuntimeException("internal error : missing set's cube");
        }
        try {
            OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
            List<OlapProperty> requestOlapProperties = XmlaServerProxy.createIcCubeProperties(requestXmlaProperties);
            OlapProperties olapProperties = olapEngineRequestContext.getOlapEngineProperties().override(requestOlapProperties);
            OlapMdxStatementWithCubeSelectExecutionContext sContext = new OlapMdxStatementWithCubeSelectExecutionContext(olapEngineRequestContext, olapProperties, null, null, schema, setCube, true);
            OlapExcelSetEvaluationContext evaluationContext = new OlapExcelSetEvaluationContext((OlapMdxStatementExecutionContext)sContext, set.isDynamicEvaluation());
            OlapEntityIdentifier setIdentifier = new OlapEntityIdentifier(new String[]{set.getSetName()});
            OlapNonScalarEntity evaluated = evaluationContext.lookupSetByMdxIdentifier(setIdentifier);
            ArrayList<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>();
            GFContext gContext = evaluationContext.createGFContext();
            IOlapPrepareContext pContext = gContext.getPrepareContext();
            if (evaluated.isToSetApplicable(pContext)) {
                OlapTupleSet asSet = evaluated.toSet(pContext);
                OlapIterator tuples = asSet.getIterator(false);
                tuples.reset();
                OlapTuple tuple = (OlapTuple)tuples.next();
                if (tuple != null) {
                    hierarchies.addAll(tuple.getTupleHierarchies());
                }
            }
            return hierarchies;
        }
        catch (RuntimeException ex) {
            OlapLoggers.XMLA_REQUEST.warn((Object)"XMLA set evaluation error", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public List<IXmlaMDSchemaKPI> getMDSchemaKPI(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        return Collections.emptyList();
    }

    public List<IXmlaMDSchemaMeasureGroup> getMDSchemaMeasureGroup(final XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        final ArrayList<IXmlaMDSchemaMeasureGroup> list = new ArrayList<IXmlaMDSchemaMeasureGroup>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) throws XmlaProxyException {
                String cubeName = cube.getName((OlapNameContext)context.getNameContext());
                Set groups = cube.getMeasureGroupNames(this.this$0.getCubePermissions(context, catalog, cube));
                for (String groupName : groups) {
                    OlapSchemaLocalization localization = catalog.getLocalization();
                    String caption = localization.getMeasureGroupCaption(context.getLocale(), cube, groupName);
                    list.add(new XmlaMDSchemaMeasureGroupBean(catalog.getName(), cubeName, groupName, caption, "-", true));
                }
            }
        });
        return list;
    }

    public List<IXmlaMDSchemaMeasureGroupDimension> getMDSchemaMeasureGroupDimension(final XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        final ArrayList<IXmlaMDSchemaMeasureGroupDimension> items = new ArrayList<IXmlaMDSchemaMeasureGroupDimension>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        this.forEachCube(context, restrictions, catalog, new ForEachCube(){
            final /* synthetic */ XmlaServerProxy this$0;
            {
                XmlaServerProxy xmlaServerProxy = this$0;
                Objects.requireNonNull(xmlaServerProxy);
                this.this$0 = xmlaServerProxy;
            }

            @Override
            public void apply(OlapSchema catalog, OlapCube cube) throws XmlaProxyException {
                Set measureGroupNames = cube.getMeasureGroupNames(this.this$0.getCubePermissions(context, catalog, cube));
                IOlapSchemaPermission schemaPermissions = XmlaServerProxy.getSchemaPermissions(context, catalog);
                IOlapDimensionsPermission dimensionsPermission = schemaPermissions.getDimensionsPermissions(cube);
                OlapNameContext nameContext = dimensionsPermission.getNamingContext(context.getNameContext());
                for (String measureGroupName : measureGroupNames) {
                    List dimensions = cube.getOwnDimensionsWithoutMeasures(dimensionsPermission, measureGroupName);
                    for (OlapDimension dimension : dimensions) {
                        items.add(new XmlaMDSchemaMeasureGroupDimensionBean(catalog.getName(), cube.getName((OlapNameContext)context.getNameContext()), measureGroupName, XmlaPropertyCardinality.ONE, dimension.getUniqueName(nameContext), XmlaPropertyCardinality.MANY, true, false, null, dimension.getBaseHierarchy().getUniqueName(nameContext)));
                    }
                }
            }
        });
        return items;
    }

    public List<IXmlaMDSchemaAction> getMDSchemaAction(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        XmlaCoordinateType coordinateType;
        boolean drillthrough;
        ArrayList<IXmlaMDSchemaAction> items = new ArrayList<IXmlaMDSchemaAction>();
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        String actionTypesB = XmlaServerProxy.getRestrictionValue(restrictions, "ACTION_TYPE");
        XmlaActionType actionTypes = CdStringUtils.isNotNullAndNotBlank((String)actionTypesB) ? XmlaServerProxy.getOptionalBitMap(restrictions, "ACTION_TYPE", XmlaActionType.MDACTION_TYPE_DRILLTHROUGH) : null;
        boolean bl = drillthrough = actionTypes != null && actionTypes.has((CdAbstractBitmapEnum)XmlaActionType.MDACTION_TYPE_DRILLTHROUGH);
        if (drillthrough && ((coordinateType = (XmlaCoordinateType)XmlaServerProxy.getRestrictionValueAsEnum(restrictions, "COORDINATE_TYPE", XmlaCoordinateType.class, null)) == XmlaCoordinateType.MDACTION_COORDINATE_CELL || coordinateType == XmlaCoordinateType.MDACTION_COORDINATE_MEMBER)) {
            OlapTuple tuple;
            String cubeName = XmlaServerProxy.getRestrictionValue(restrictions, "CUBE_NAME");
            String coordinate = XmlaServerProxy.getRestrictionValue(restrictions, "COORDINATE");
            if (cubeName != null && coordinate != null && (tuple = this.lookupTupleForAction(context, properties, cubeName, coordinate)) != null) {
                String application = "";
                XmlaCubeSource cubeSource = null;
                if (tuple.isCalculated()) {
                    String schemaName = "[" + CdMdxUtils.escape((String)catalog.getName()) + "]";
                    String dtStatement = "DRILLTHROUGH SELECT " + coordinate + " on 0 FROM " + schemaName;
                    OlapBabylonService babylon = context.getBabylon();
                    String dtName = babylon.translate("calcMemberDefaultDrillthroughAction", new Serializable[0]);
                    items.add((IXmlaMDSchemaAction)new XmlaMDSchemaActionBean(catalog.getName(), cubeName, dtName, XmlaActionType.MDACTION_TYPE_DRILLTHROUGH, coordinate, coordinateType, dtName, null, dtStatement, "", XmlaActionInvocation.MDACTION_INVOCATION_INTERACTIVE, cubeSource));
                }
                try {
                    List actions = catalog.getDrillthroughActions(cubeName, tuple);
                    actions.stream().forEach(a -> items.add((IXmlaMDSchemaAction)new XmlaMDSchemaActionBean(catalog.getName(), cubeName, a.getName(), XmlaActionType.MDACTION_TYPE_DRILLTHROUGH, coordinate, coordinateType, a.getName(), null, a.getStatement(cubeName, coordinate), "", XmlaActionInvocation.MDACTION_INVOCATION_INTERACTIVE, cubeSource)));
                }
                catch (Exception ex) {
                    OlapLoggers.XMLA_REQUEST.warn((Object)("ACTIONS: could not retrieve additional drillthrough actions for [ " + coordinate + " ]"), (Throwable)ex);
                    return null;
                }
            }
        }
        return items;
    }

    @Nullable
    private OlapTuple lookupTupleForAction(XmlaQueryContext context, List<XmlaProperty> properties, String cubeName, String memberUniqueName) {
        try {
            OlapEntity entity = this.executeMdxValueExpression(context, properties, cubeName, memberUniqueName);
            if (entity instanceof OlapTuple) {
                return (OlapTuple)entity;
            }
            OlapLoggers.XMLA_REQUEST.warn((Object)("ACTIONS: unexpected MDX entity [ " + memberUniqueName + " ] : " + String.valueOf(entity.getClass())));
            return null;
        }
        catch (Exception ex) {
            OlapLoggers.XMLA_REQUEST.warn((Object)("ACTIONS: could not retrieve the MDX entity [ " + memberUniqueName + " ]"), (Throwable)ex);
            return null;
        }
    }

    public IXmlaMDDataSet executeMDXStatement(final XmlaQueryContext context, final String statement, List<XmlaProperty> properties) throws XmlaProxyException {
        IXmlaMDDataSet result = this.executeQuery(context, statement, properties, new MdxResultProcessor<IXmlaMDDataSet>(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public IXmlaMDDataSet processResult(OlapResStatementDataSetWrapper resultWrapper) throws XmlaProxyException {
                OlapResStatementDataSet statementResult = resultWrapper.getStatement();
                if (statementResult != null) {
                    return new XmlaServerDataSetHelper(statementResult).process(context, statement);
                }
                OlapResScriptDataSet scriptResult = resultWrapper.getScript();
                if (scriptResult != null) {
                    return new XmlaServerDataSetScriptHelper(scriptResult).process(context, statement);
                }
                throw new RuntimeException("internal error: unexpected missing query result");
            }
        });
        return result;
    }

    public IXmlaRowSet executeMDXStatementAsRowSet(final XmlaQueryContext context, final String statement, List<XmlaProperty> properties) throws XmlaProxyException {
        final Boolean flattened2 = XmlaServerProxy.getPropertyValue(properties, XmlaDbpropMsmdFlattened2Property.class, false);
        if (flattened2 == null) {
            throw new RuntimeException("internal error : missing DbpropMsmdFlattened2 default value!");
        }
        IXmlaRowSet result = this.executeQuery(context, statement, properties, new MdxResultProcessor<IXmlaRowSet>(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public IXmlaRowSet processResult(OlapResStatementDataSetWrapper resultWrapper) throws XmlaProxyException {
                OlapResStatementDataSet statementResult = resultWrapper.getStatement();
                if (statementResult != null) {
                    return new XmlaServerRowSetHelper(statementResult).process(context, statement, flattened2);
                }
                OlapResScriptDataSet scriptResult = resultWrapper.getScript();
                if (scriptResult != null) {
                    return new XmlaServerRowSetScriptHelper(scriptResult).process(context, statement, flattened2);
                }
                throw new RuntimeException("internal error: unexpected missing query result");
            }
        });
        return result;
    }

    private <T> T executeQuery(XmlaQueryContext context, String statement, List<XmlaProperty> properties, MdxResultProcessor<T> processor) throws XmlaProxyException {
        ICompilationInfo compilationInfo = context.getMdxCompilationInfo();
        OlapResStatementDataSetWrapper compilationResult = compilationInfo.getResultX();
        if (compilationResult.hasResult()) {
            return this.asXmlaDataSet(processor, compilationResult);
        }
        IExecuteStatementInstr statementInstr = compilationInfo.getInstr();
        if (statementInstr == null) {
            throw new RuntimeException("internal error: missing MDX evaluation instruction");
        }
        IcCubeSchemaAccessLockMode schemaAccessLockMode = statementInstr.getSchemaAccessLockMode();
        OlapSchema schema = XmlaServerProxy.getExistingCatalog(schemaAccessLockMode, context, properties);
        OlapEngineMdxHelper helper = compilationInfo.getHelper();
        if (compilationInfo instanceof OlapEngineMdxStatementCompilationInfo) {
            OlapEngineMdxStatementCompilationInfo compilationInfo_ = (OlapEngineMdxStatementCompilationInfo)compilationInfo;
            OlapResStatementDataSet result = helper.executeMdxStatement(compilationInfo_, schema);
            return this.asXmlaDataSet(processor, new OlapResStatementDataSetWrapper(result));
        }
        if (compilationInfo instanceof OlapEngineMdxScriptCompilationInfo) {
            OlapEngineMdxScriptCompilationInfo compilationInfo_ = (OlapEngineMdxScriptCompilationInfo)compilationInfo;
            OlapResScriptDataSet result = helper.executeMdxScript(compilationInfo_.asExecutionInfo(), schema);
            return this.asXmlaDataSet(processor, new OlapResStatementDataSetWrapper(result));
        }
        throw new RuntimeException("internal error: unexpected compilation result [" + compilationInfo.getClass().getName() + "]");
    }

    private <T> T asXmlaDataSet(MdxResultProcessor<T> processor, OlapResStatementDataSetWrapper result) throws XmlaProxyException {
        ICdException error = result.getException();
        if (error != null) {
            throw new XmlaServerProxyException(error);
        }
        return processor.processResult(result);
    }

    private OlapEntity executeMdxValueExpression(XmlaQueryContext context, @Nullable List<XmlaProperty> properties, String cubeName, String mdx) throws XmlaProxyException {
        List<OlapProperty> olapProperties = XmlaServerProxy.createIcCubeProperties(properties);
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
        OlapEngineMdxHelper helper = OlapEngineMdxHelper.create((OlapEngineRequestContext)olapEngineRequestContext, null, olapProperties);
        try {
            return helper.executeMdxValueExpression(catalog, cubeName, mdx, "xmla-?");
        }
        catch (CdMdxException scanError) {
            throw new XmlaServerProxyException((ICdException)scanError);
        }
    }

    public List<IXmlaDMSchemaMiningModels> getDMSchemaMiningModels(XmlaQueryContext context, List<IXmlaDMSchemaMiningModels> restrictions, List<XmlaProperty> properties) {
        return Collections.emptyList();
    }

    public List<IXmlaDiscoverXmlMetaData> getXmlMetaData(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        ArrayList<IXmlaDiscoverXmlMetaData> metaData = new ArrayList<IXmlaDiscoverXmlMetaData>();
        String serverId = XmlaServerProxy.getServerName();
        metaData.add((IXmlaDiscoverXmlMetaData)new XmlaDiscoverXmlMetaDataBean(serverId, PROVIDER_VERSION, this.getAllAuthorizedSchemaName(context)));
        return metaData;
    }

    public List<IXmlaDiscoverCsdlMetaData> getCsdlMetaData(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) throws XmlaProxyException {
        OlapSchema catalog = XmlaServerProxy.getExistingCatalogReadMode(context, properties);
        String cube = XmlaServerProxy.getPropertyValue(properties, "Cube");
        String version = XmlaServerProxy.getRestrictionValue(restrictions, "VERSION");
        String perspective = XmlaServerProxy.getRestrictionValue(restrictions, "PERSPECTIVE_NAME");
        ArrayList<IXmlaDiscoverCsdlMetaData> metaData = new ArrayList<IXmlaDiscoverCsdlMetaData>();
        metaData.add((IXmlaDiscoverCsdlMetaData)new XmlaDiscoverCsdlMetaDataBean(version));
        return metaData;
    }

    public List<IXmlaMDSchemaFunction> getDiscoverDBSchemaFunctions(XmlaQueryContext context, List<XmlaRestriction> restrictions, List<XmlaProperty> properties) {
        OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapFunctionRepository functionRepository = olapEngine.getFunctionRepository();
        return new ArrayList<IXmlaMDSchemaFunction>(new XmlaFunctionRepository(functionRepository).getAllFunctions());
    }

    @Nullable
    private String resolveSetCubeName(XmlaQueryContext context, OlapSchema schema, @Nullable String cubeName) {
        if (cubeName == null) {
            return null;
        }
        OlapRequestNamesContext schemaNameContext = context.getNameContext();
        IOlapSchemaPermission schemaPermissions = XmlaServerProxy.getSchemaPermissions(context, schema);
        OlapCube cube = schema.lookupCubeByName(schemaPermissions, (OlapNameContext)schemaNameContext, cubeName);
        if (cube == null) {
            return cubeName;
        }
        return cube.getName((OlapNameContext)schemaNameContext);
    }

    @Nullable
    public static OlapCube getCube(XmlaQueryContext context, OlapSchema schema, String cubeName) {
        OlapRequestNamesContext schemaNameContext = context.getNameContext();
        IOlapSchemaPermission schemaPermissions = XmlaServerProxy.getSchemaPermissions(context, schema);
        return schema.lookupCubeByName(schemaPermissions, (OlapNameContext)schemaNameContext, cubeName);
    }

    private static IOlapSchemaPermission getSchemaPermissions(XmlaQueryContext context, OlapSchema schema) {
        OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
        OlapRolePermissions permissions = olapEngineRequestContext.getCurrentPermissions();
        IOlapSchemasPermission schemasPermissions = permissions.getSchemasPermissions();
        IOlapSchemaPermission schemaPermissions = schemasPermissions.getSchemaPermissions(olapEngineRequestContext, schema, true);
        return schemaPermissions;
    }

    private IOlapCubePermission getCubePermissions(XmlaQueryContext context, OlapSchema schema, OlapCube cube) {
        IOlapSchemaPermission schemaPermissions = XmlaServerProxy.getSchemaPermissions(context, schema);
        return schemaPermissions.getCubePermissions(cube);
    }

    public static IOlapDimensionsPermission getDimensionsPermissions(XmlaQueryContext context, OlapSchema schema, @Nullable OlapCube cube) {
        IOlapSchemaPermission schemaPermissions = XmlaServerProxy.getSchemaPermissions(context, schema);
        return schemaPermissions.getDimensionsPermissions(cube);
    }

    private IOlapDimensionPermission getDimensionPermissions(XmlaQueryContext context, OlapSchema schema, OlapCube cube, OlapDimension dimension) {
        IOlapDimensionsPermission dimensionsPermissions = XmlaServerProxy.getDimensionsPermissions(context, schema, cube);
        return dimensionsPermissions.getDimensionPermissions(dimension);
    }

    private IOlapHierarchyPermission getHierarchyPermissions(XmlaQueryContext context, OlapSchema schema, OlapCube cube, OlapHierarchy hierarchy) {
        IOlapDimensionPermission dimensionPermissions = this.getDimensionPermissions(context, schema, cube, hierarchy.getDimension());
        return dimensionPermissions.getHierarchyPermission(hierarchy);
    }

    private IOlapSchemaPermission getSchemaPermissionsWithoutPerspective(XmlaQueryContext context, OlapSchema schema) {
        OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
        OlapRolePermissions permissions = olapEngineRequestContext.getCurrentPermissions();
        IOlapSchemasPermission schemasPermissions = permissions.getSchemasPermissions();
        IOlapSchemaPermission schemaPermissions = schemasPermissions.getSchemaPermissions(olapEngineRequestContext, schema, false);
        return schemaPermissions;
    }

    private IOlapDimensionsPermission getDimensionPermissionsWithoutPerspective(XmlaQueryContext context, OlapSchema schema, OlapCube cube) {
        IOlapSchemaPermission schemaPermissions = this.getSchemaPermissionsWithoutPerspective(context, schema);
        return schemaPermissions.getDimensionsPermissions(cube);
    }

    @Nullable
    private OlapMemberFilter getSchemaPermissionsMemberFilter(XmlaQueryContext context, OlapSchema schema, OlapCube cube) {
        return XmlaServerProxy.getDimensionsPermissions(context, schema, cube).getMemberFilter();
    }

    @Nullable
    private OlapMemberFilter getSchemaPermissionsInvisibleMemberFilter(XmlaQueryContext context, OlapSchema schema, OlapCube cube) {
        return XmlaServerProxy.getDimensionsPermissions(context, schema, cube).getInvisibleMemberFilter();
    }

    private List<OlapDimension> getCubeDimensions(OlapCube cube, IOlapDimensionsPermission dimensionsPermission) {
        return cube.getOwnDimensions(dimensionsPermission);
    }

    @Nullable
    public static OlapSchema getSchema(XmlaQueryContext context, IcCubeSchemaAccessLockMode mode, String schemaName) {
        OlapEngineRequestContext olapEngineRequestContext = context.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        return olapEngine.getAuthorizedSchema(olapEngineRequestContext, mode, schemaName);
    }

    private void forEachCube(XmlaQueryContext context, List<XmlaRestriction> restrictions, OlapSchema catalog, ForEachCube action) throws XmlaProxyException {
        String cubeName = XmlaServerProxy.getRestrictionValue(restrictions, "CUBE_NAME");
        if (cubeName != null) {
            OlapCube cube = XmlaServerProxy.getCube(context, catalog, cubeName);
            if (cube != null) {
                action.apply(catalog, cube);
            }
        } else {
            IOlapSchemaPermission permissions = XmlaServerProxy.getSchemaPermissions(context, catalog);
            List cubes = catalog.getCubes(permissions);
            for (int i = 0; i < cubes.size(); ++i) {
                OlapCube cube = (OlapCube)cubes.get(i);
                action.apply(catalog, cube);
            }
        }
    }

    private List<OlapMember> getCalcMembers(XmlaQueryContext context, OlapCube cube) {
        OlapSchema schema = cube.getSchema();
        OlapEngineSessionContext session = context.getOlapEngineRequestContext().getSessionContext();
        IOlapCalculatedMembers sessionCalcMembers = session.getCalcMemberManagerForLookup(schema, (OlapCalculatedMemberManager)cube.getCalcMemberManager());
        List members = sessionCalcMembers.getVisibleCalculatedMembers(null);
        return members;
    }

    private static String coalesceNull(@Nullable String value, String coalesce) {
        return value != null ? value : coalesce;
    }

    @Nullable
    public String getFirstAuthorizedSchemaName(XmlaQueryContext context) {
        List<IXmlaDBSchemaCatalogs> catalogs = this.getDiscoverDBSchemaCatalogs(context, Collections.emptyList(), Collections.emptyList());
        List<String> names = catalogs.stream().map(IXmlaDBSchemaCatalogs::getCatalogName).toList();
        return !names.isEmpty() ? names.getFirst() : null;
    }

    public List<String> getAllAuthorizedSchemaName(XmlaQueryContext context) {
        List<IXmlaDBSchemaCatalogs> catalogs = this.getDiscoverDBSchemaCatalogs(context, Collections.emptyList(), Collections.emptyList());
        List<String> names = catalogs.stream().map(IXmlaDBSchemaCatalogs::getCatalogName).toList();
        return names;
    }

    @Nullable
    public String fixDisplayFolder(XmlaQueryContext context, @Nullable String folder) {
        if (folder == null) {
            return folder;
        }
        CdXmlaCaller caller = context.getXmlaCaller();
        if (!CdXmlaCaller.Tableau.equals((Object)caller)) {
            return folder;
        }
        String[] parts = folder.split(";");
        if (parts.length > 0) {
            String part0 = parts[0];
            String replaced = part0.replace("\\", "/");
            if (replaced.startsWith("/") && replaced.lastIndexOf("/") == 0) {
                return replaced.substring(1);
            }
            return replaced;
        }
        return folder;
    }

    static interface ForEachCube {
        public void apply(OlapSchema var1, OlapCube var2) throws XmlaProxyException;
    }

    static class MemberPropertyHelper {
        final OlapMemberPropertyEvalContext pEvalContext;
        boolean requireProperties = true;
        OlapLevel uLevel;

        MemberPropertyHelper(Locale locale, OlapNameContext nameContext, IOlapDimensionsPermission perms, String cubeName) {
            this.pEvalContext = new OlapMemberPropertyEvalContext(locale, nameContext, perms, cubeName);
        }

        boolean requirePropertyEval() {
            return this.uLevel != null;
        }

        void assertEvaluatedProperties(List<IXmlaMDSchemaMember> members) {
            if (!this.requirePropertyEval()) {
                for (IXmlaMDSchemaMember member : members) {
                    member.clearProperties();
                }
            }
        }

        @Nullable
        XmlaMDSchemaMemberProperties evalProperties(@Nullable OlapMemberFilter memberFilter, OlapMember member) {
            List properties;
            if (!this.requireProperties) {
                return null;
            }
            if (this.uLevel != null && !this.uLevel.equals((Object)member.getLevel())) {
                this.requireProperties = false;
                this.uLevel = null;
                return null;
            }
            if (this.uLevel == null) {
                this.uLevel = member.getLevel();
            }
            if ((properties = this.uLevel.getMemberProperties(memberFilter)).isEmpty()) {
                this.requireProperties = false;
                this.uLevel = null;
                return null;
            }
            ArrayList<XmlaMDSchemaMemberProperty> definitions = new ArrayList<XmlaMDSchemaMemberProperty>();
            ArrayList<XmlaMDSchemaMemberPropertyValue> values = new ArrayList<XmlaMDSchemaMemberPropertyValue>();
            for (OlapUserDefinedMemberProperty property : properties) {
                OlapScalarEntity value = property.eval(this.pEvalContext, member);
                XmlaPropertyValue pValue = new XmlaPropertyValue(value);
                String name = property.getName();
                CdXmlaSchemaType xmlaType = property.getXmlaType();
                definitions.add(new XmlaMDSchemaMemberProperty(name, xmlaType));
                values.add(pValue.asMDSchemaMemberPropertyValue());
            }
            return new XmlaMDSchemaMemberProperties(definitions, values);
        }
    }

    private static interface MdxResultProcessor<T> {
        public T processResult(OlapResStatementDataSetWrapper var1) throws XmlaProxyException;
    }
}

