/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.engine;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.olap.component.context.cache.OlapMdxResultCacheInfo;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheKey;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreReferenceKey;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.types.XmlaFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class XmlaResultStoreReferenceKey
extends OlapResultStoreReferenceKey {
    private static long SHALLOW_SIZE_OF = -1L;
    private final XmlaFormat resultFormat;
    private final CdXmlaCaller caller;
    private final Property[] properties;
    private final String mdx;

    public XmlaResultStoreReferenceKey(XmlaFormat resultFormat, CdXmlaCaller caller, List<XmlaProperty> properties, String mdx) {
        this.resultFormat = resultFormat;
        this.caller = caller;
        this.properties = new Property[properties.size()];
        for (int ii = 0; ii < properties.size(); ++ii) {
            XmlaProperty property = properties.get(ii);
            this.properties[ii] = new Property(property.getName(), property.toXmlaString());
        }
        Arrays.sort(this.properties, new Comparator<Property>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(Property o1, Property o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        this.mdx = mdx;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)((Object)this)));
        size += this.caller.sizeOf();
        size += CdRamUsageEstimator.shallowSizeOf((Object[])this.properties);
        for (Property property : this.properties) {
            size += property.sizeOf();
        }
        return size += CdRamUsageEstimator.sizeOf((Integer)this.mdx.length());
    }

    public String getMdx() {
        return this.mdx;
    }

    public int getMdxSize() {
        return this.mdx.length();
    }

    @Nullable
    public OlapMdxResultCacheInfo asMdxResultCacheInfo(OlapResultCacheKey cache) {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        XmlaResultStoreReferenceKey that = (XmlaResultStoreReferenceKey)((Object)o);
        if (this.mdx != null ? !this.mdx.equals(that.mdx) : that.mdx != null) {
            return false;
        }
        if (!Arrays.equals(this.properties, that.properties)) {
            return false;
        }
        if (this.resultFormat != that.resultFormat) {
            return false;
        }
        return !(this.caller != null ? !this.caller.equals((Object)that.caller) : that.caller != null);
    }

    public int hashCode() {
        int result = this.resultFormat != null ? this.resultFormat.hashCode() : 0;
        result = 31 * result + (this.caller != null ? this.caller.hashCode() : 0);
        result = 31 * result + (this.properties != null ? Arrays.hashCode(this.properties) : 0);
        result = 31 * result + (this.mdx != null ? this.mdx.hashCode() : 0);
        return result;
    }

    static class Property {
        private static long P_SHALLOW_SIZE_OF = -1L;
        final String name;
        final String value;

        Property(String name, String value) {
            this.name = name;
            this.value = value;
        }

        long sizeOf() {
            long size = P_SHALLOW_SIZE_OF != -1L ? P_SHALLOW_SIZE_OF : (P_SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
            size += CdRamUsageEstimator.sizeOf((String)this.name);
            return size += CdRamUsageEstimator.sizeOf((String)this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            if (this.name != null ? !this.name.equals(property.name) : property.name != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(property.value) : property.value != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

