/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.engine;

import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.xmla.model.proxy.IXmlaSessionContext;
import jakarta.servlet.http.HttpSession;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

@CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
public class XmlaQuerySessionContext
implements IXmlaSessionContext {
    public static final String SERVLET_CONTEXT_KEY = "icCubeServer.xmlaSessionContext";
    @Nullable
    private final HttpSession httpSession;
    private final String sessionId;
    private final Set<String> activeRequests = new HashSet<String>();

    public XmlaQuerySessionContext(@Nullable HttpSession httpSession, String sessionId) {
        this.httpSession = httpSession;
        this.sessionId = sessionId;
    }

    @Nullable
    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveRequest(String uuid) {
        Set<String> set = this.activeRequests;
        synchronized (set) {
            this.activeRequests.add(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveRequest(String uuid) {
        Set<String> set = this.activeRequests;
        synchronized (set) {
            this.activeRequests.remove(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getActiveRequests() {
        Set<String> set = this.activeRequests;
        synchronized (set) {
            return new HashSet<String>(this.activeRequests);
        }
    }

    public String toString() {
        return this.sessionId;
    }
}

