/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.server.engine;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.xmla.CdXmlaCaller;
import crazydev.iccube.babylon.OlapBabylonService;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.mdx.ICompilationInfo;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.pub.authorization.IOlapPermissionsService;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.proxy.IXmlaRequestContext;
import crazydev.xmla.server.iccube.server.engine.XmlaQuerySessionContext;
import crazydev.xmla.server.iccube.server.engine.XmlaServerProxy;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class XmlaQueryContext
implements IXmlaRequestContext<XmlaQuerySessionContext> {
    @Nullable
    private final XmlaQuerySessionContext xmlaQuerySessionContext;
    private final IOlapPermissionsService rolePermissionsService;
    private final XmlaServerProxy xmlaEngine;
    @Nullable
    private final Map httpParameters;
    private final CdXmlaCaller caller;
    private OlapEngineRequestContext olapEngineRequestContext;
    @Nullable
    private File schemaFactoryFile;
    private boolean keepLastResult;
    private OlapResSelectStatementDataSet lastResult;
    @Nullable
    private ICompilationInfo mdxCompilationInfo;

    public XmlaQueryContext(@Nullable XmlaQuerySessionContext xmlaQuerySessionContext, IOlapPermissionsService rolePermissionsService, XmlaServerProxy xmlaEngine, Map httpParameters, CdXmlaCaller caller) {
        this.xmlaQuerySessionContext = xmlaQuerySessionContext;
        this.rolePermissionsService = rolePermissionsService;
        this.xmlaEngine = xmlaEngine;
        this.httpParameters = httpParameters;
        this.caller = caller;
    }

    public CdXmlaCaller getXmlaCaller() {
        return this.caller;
    }

    public CdXmlaCaller getBehaviorsForResultStoreKey() {
        return this.caller.toResultStoreKey();
    }

    @Nullable
    public XmlaQuerySessionContext getXmlaQuerySessionContext() {
        return this.xmlaQuerySessionContext;
    }

    public IOlapPermissionsService getRolePermissionsService() {
        return this.rolePermissionsService;
    }

    public String getSessionId() {
        return this.xmlaQuerySessionContext != null ? this.xmlaQuerySessionContext.getSessionId() : null;
    }

    public XmlaServerProxy getXmlaEngine() {
        return this.xmlaEngine;
    }

    public OlapEngineRequestContext getOlapEngineRequestContext() {
        if (this.olapEngineRequestContext == null) {
            throw new CdProgrammingException("internal error : missing MDX request context");
        }
        return this.olapEngineRequestContext;
    }

    public OlapBabylonService getBabylon() {
        return this.olapEngineRequestContext.getBabylonService();
    }

    public void setOlapEngineRequestContext(OlapEngineRequestContext olapEngineRequestContext) {
        this.olapEngineRequestContext = olapEngineRequestContext;
    }

    public Locale getLocale() {
        return this.getOlapEngineRequestContext().getLocale();
    }

    public boolean isBackupLicensed() {
        OlapEngineApplicationContext olapEngineApplicationContext = this.getOlapEngineRequestContext().getApplicationContext();
        return olapEngineApplicationContext.isBackupLicensed();
    }

    public boolean isTablePartitioningLicensed() {
        OlapEngineApplicationContext olapEngineApplicationContext = this.getOlapEngineRequestContext().getApplicationContext();
        return olapEngineApplicationContext.isTablePartitioningLicensed();
    }

    public boolean isFactsPartitioningLicensed() {
        OlapEngineApplicationContext olapEngineApplicationContext = this.getOlapEngineRequestContext().getApplicationContext();
        return olapEngineApplicationContext.isFactsPartitioningLicensed();
    }

    public IOlapPermissionsService getRoleService() {
        OlapEngineApplicationContext olapEngineApplicationContext = this.getOlapEngineRequestContext().getApplicationContext();
        return olapEngineApplicationContext.getAuthorizationService();
    }

    public boolean isManagementApiAvailable() {
        OlapEngineApplicationContext olapEngineApplicationContext = this.getOlapEngineRequestContext().getApplicationContext();
        return olapEngineApplicationContext.isManagementApiLicensed();
    }

    public IcCubeRequestStatusManager getRequestStatusManager() {
        OlapEngineApplicationContext olapEngineApplicationContext = this.getOlapEngineRequestContext().getApplicationContext();
        return olapEngineApplicationContext.getRequestStatusManager();
    }

    @Nullable
    public File getSchemaFactoryFile() {
        return this.schemaFactoryFile;
    }

    public void setSchemaFactoryFile(@Nullable File schemaFactoryFile) {
        this.schemaFactoryFile = schemaFactoryFile;
    }

    public ICompilationInfo getMdxCompilationInfo() {
        if (this.mdxCompilationInfo == null) {
            throw new RuntimeException("internal error: missing MDX compilation information");
        }
        return this.mdxCompilationInfo;
    }

    public void setMdxCompilationInfo(ICompilationInfo compilationInfo) {
        this.mdxCompilationInfo = compilationInfo;
    }

    public boolean isKeepLastResult() {
        return this.keepLastResult;
    }

    public void setKeepLastResult(boolean val) {
        this.keepLastResult = true;
    }

    public OlapResSelectStatementDataSet getLastResult() {
        return this.lastResult;
    }

    public void setLastResult(OlapResSelectStatementDataSet lastResult) {
        this.lastResult = lastResult;
    }

    public List<OlapSetDeclaration> getSessionSetDeclarations(OlapSchema schema) {
        OlapEngineSessionContext sessionContext = this.olapEngineRequestContext.getSessionContext();
        return sessionContext.getSetDeclarations(schema);
    }

    public OlapRequestNamesContext getNameContext() {
        return this.olapEngineRequestContext.getNameContext();
    }

    @Nullable
    public OlapSchema getSchema(IcCubeSchemaAccessLockMode mode, List<XmlaProperty> properties, String schemaName) {
        OlapEngineRequestContext olapEngineRequestContext = this.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = olapEngineRequestContext.getOlapEngineComponent();
        OlapSchema schema = olapEngine.getAuthorizedSchema(olapEngineRequestContext, mode, schemaName);
        return schema;
    }
}

