/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.rowset;

import crazydev.common.collection.CdSingleItemList;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapEmptyIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.properties.cell.OlapIntrinsicCellProperties;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberProperties;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyEvalContext;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.entity.result.OlapResAxis;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.result.OlapResIntrinsicScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.tuple.OlapBlankTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.rowset.IXmlaRowSetDataRow;
import crazydev.xmla.model.rowset.XmlaAbstractRowSet;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class XmlaRowSet
extends XmlaAbstractRowSet {
    private final DataRowClone titleRow;
    private final ArrayList<IXmlaRowSetDataRow> rows = new ArrayList();

    public XmlaRowSet(OlapResSelectStatementDataSet result, IOlapDimensionsPermission perms, boolean flattened2) {
        if (result.isBlank()) {
            throw new RuntimeException("internal error : unexpected blank dataset");
        }
        OlapNameContext nameContext = result.getNameContext();
        Impl impl = new Impl(result, perms, flattened2);
        this.titleRow = new DataRowClone(impl.getTitle(nameContext));
        for (IXmlaRowSetDataRow dataRow : impl.getRows(nameContext)) {
            this.rows.add(new DataRowClone(dataRow));
        }
    }

    public boolean isBlank() {
        return false;
    }

    public IXmlaRowSetDataRow getTitle() {
        if (this.isBlank()) {
            throw new CdShouldNotBeHereProgrammingException("internal error: blank rowset not serialized this way!");
        }
        return this.titleRow;
    }

    public Iterable<IXmlaRowSetDataRow> getRows() {
        if (this.isBlank()) {
            throw new CdShouldNotBeHereProgrammingException("internal error: blank rowset not serialized this way!");
        }
        return this.rows;
    }

    private static class Impl {
        private final OlapResSelectStatementDataSet result;
        private final Map<OlapMember, OlapMemberPropertyValues> memberPropertyValues = new HashMap<OlapMember, OlapMemberPropertyValues>();
        private final OlapNameContext nameContext;
        private List<IXmlaRowSetColumn> columns = new ArrayList<IXmlaRowSetColumn>();
        private OlapIterator<OlapTuple> rowIterator;
        private OlapIterator<OlapTuple> columnIterator;
        private int beginValuePos;
        private final boolean hasOneAxis;
        private OlapMemberPropertyEvalContext context;

        public Impl(OlapResSelectStatementDataSet result, IOlapDimensionsPermission perm, boolean flattened2) {
            OlapMdxStatementExecutionContext resultContext = result.getContext();
            this.nameContext = result.getNameContext();
            this.context = new OlapMemberPropertyEvalContext(resultContext.getLocale(), resultContext.getNameContext(), perm, result.getCubeName());
            List<OlapTuple> columnTuples = this.getColumnTuples(result);
            this.columnIterator = OlapIteratorFactory.instance(columnTuples);
            OlapResAxis rowAxis = result.getRowAxis();
            boolean bl = this.hasOneAxis = rowAxis == null;
            if (columnTuples.isEmpty()) {
                this.rowIterator = OlapEmptyIterator.INSTANCE;
            } else {
                Object rowTuples = this.hasOneAxis ? new CdSingleItemList((Object)OlapBlankTuple.INSTANCE) : rowAxis.getTuples();
                this.rowIterator = OlapIteratorFactory.instance((List)rowTuples);
            }
            this.result = result;
            if (result.getAxes().length > 2) {
                throw new CdRuntimeException("Not Yet supported");
            }
            this.addColumnsRows(result, flattened2);
        }

        private List<OlapTuple> getColumnTuples(OlapResSelectStatementDataSet result) {
            if (result.getAxisCount() == 0) {
                return new ArrayList<OlapTuple>();
            }
            return result.getColumnAxis().getTuples();
        }

        public IXmlaRowSetDataRow getTitle(OlapNameContext nameContext) {
            return new XmlaRowSetRow(this, nameContext, null, 0);
        }

        public Iterable<IXmlaRowSetDataRow> getRows(final OlapNameContext nameContext) {
            this.rowIterator.reset();
            return new Iterable<IXmlaRowSetDataRow>(){
                final /* synthetic */ Impl this$0;
                {
                    Impl impl = this$0;
                    Objects.requireNonNull(impl);
                    this.this$0 = impl;
                }

                @Override
                public Iterator<IXmlaRowSetDataRow> iterator() {
                    return new Iterator<IXmlaRowSetDataRow>(){
                        public OlapTuple item;
                        int rowNumber;
                        final /* synthetic */ 1 this$1;
                        {
                            1 v0 = this$1;
                            Objects.requireNonNull(v0);
                            this.this$1 = v0;
                            this.rowNumber = -1;
                        }

                        @Override
                        public boolean hasNext() {
                            this.item = (OlapTuple)this.this$1.this$0.rowIterator.next();
                            ++this.rowNumber;
                            return this.item != null;
                        }

                        @Override
                        public IXmlaRowSetDataRow next() {
                            return new XmlaRowSetRow(this.this$1.this$0, nameContext, this.item, this.rowNumber);
                        }

                        @Override
                        public void remove() {
                        }
                    };
                }
            };
        }

        private void addColumnsRows(OlapResSelectStatementDataSet result, boolean flattened2) {
            if (result.getAxisCount() == 0) {
                return;
            }
            OlapResAxis onColumns = result.getColumnAxis();
            OlapResAxis onRows = result.getRowAxis();
            if (onRows != null) {
                this.addRows(onColumns, onRows, flattened2);
            }
            this.beginValuePos = this.columns.size();
            this.addColumns(onColumns);
            this.memberPropertyValues.putAll(result.getAllMemberPropertyValues());
        }

        private void addRows(OlapResAxis onColumns, OlapResAxis onRows, boolean flattened2) {
            int i;
            OlapTuple tuple;
            OlapTuple anyTuple = onRows.getAnyTuple();
            if (anyTuple == null) {
                return;
            }
            Set[] levels = this.initializeArray(anyTuple);
            OlapIterator iter = OlapIteratorFactory.instance((List)onRows.getTuples());
            while ((tuple = (OlapTuple)iter.next()) != null) {
                for (i = 0; i < tuple.getMemberCount(); ++i) {
                    OlapMember olapMember = tuple.getMember(i);
                    OlapLevel olapLevel = olapMember.getLevel();
                    OlapHierarchy hierarchy = olapLevel.getHierarchy();
                    boolean flatten = hierarchy.isParentChild() ? false : false;
                    while (olapLevel != null && levels[i].add(olapLevel) && !flatten) {
                        olapLevel = olapLevel.getPreviousLevel();
                    }
                }
            }
            for (i = 0; i < levels.length; ++i) {
                for (Object o : levels[i]) {
                    OlapLevel level = (OlapLevel)o;
                    List onRowsProperties = onRows.getRequestedProperties();
                    boolean containsCaption = false;
                    for (OlapResScopedDimensionProperty property : onRowsProperties) {
                        if (property.isCaption()) {
                            containsCaption = true;
                        }
                        this.columns.add(new XmlaRowSetColumn(this, level, property));
                    }
                    if (containsCaption) continue;
                    this.columns.add(new XmlaRowSetColumn(this, level, (OlapResScopedDimensionProperty)new OlapResIntrinsicScopedDimensionProperty(OlapIntrinsicMemberProperties.MEMBER_CAPTION, null)));
                }
            }
        }

        private void addColumns(OlapResAxis onColumns) {
            OlapTuple tuple;
            OlapIterator iter = OlapIteratorFactory.instance((List)onColumns.getTuples());
            while ((tuple = (OlapTuple)iter.next()) != null) {
                this.columns.add(new XmlaRowSetColumnValue(tuple));
            }
        }

        private Set[] initializeArray(OlapTuple tuple) {
            Set[] levels = new Set[tuple.getMemberCount()];
            for (int i = 0; i < levels.length; ++i) {
                levels[i] = new TreeSet<OlapLevel>(new Comparator<OlapLevel>(this){
                    {
                        Objects.requireNonNull(this$0);
                    }

                    @Override
                    public int compare(OlapLevel o1, OlapLevel o2) {
                        return Integer.valueOf(o1.getDepth()).compareTo(o2.getDepth());
                    }
                });
            }
            return levels;
        }

        public class XmlaRowSetRow
        implements IXmlaRowSetDataRow {
            private final OlapNameContext nameContext;
            @Nullable
            private final OlapTuple rowMember;
            private final int row;
            final /* synthetic */ Impl this$0;

            public XmlaRowSetRow(Impl this$0, @Nullable OlapNameContext nameContext, OlapTuple item, int row) {
                Impl impl = this$0;
                Objects.requireNonNull(impl);
                this.this$0 = impl;
                this.nameContext = nameContext;
                this.rowMember = item;
                this.row = row;
            }

            public int size() {
                return this.this$0.columns.size();
            }

            @Nullable
            public XmlaPropertyValue get(int col) {
                XmlaPropertyValue value;
                if (this.rowMember == null) {
                    return new XmlaPropertyValue((OlapScalarEntity)new OlapStringEntity(this.this$0.columns.get(col).getTitle(this.nameContext)));
                }
                if (col < this.this$0.beginValuePos) {
                    value = this.this$0.columns.get(col).getValue(this.rowMember, null, null);
                } else {
                    OlapTuple colMember = (OlapTuple)this.this$0.columnIterator._getSlow(col);
                    OlapResCell cell = this.this$0.hasOneAxis ? this.this$0.result.getCells().getCell(col - this.this$0.beginValuePos) : this.this$0.result.getCells().getCell(new int[]{col - this.this$0.beginValuePos, this.row});
                    value = this.this$0.columns.get(col).getValue(this.rowMember, colMember, cell);
                }
                return value;
            }

            public String getXmlElementName(int col) {
                return "c" + col;
            }
        }

        private class XmlaRowSetColumn
        implements IXmlaRowSetColumn {
            private final OlapLevel level;
            private final OlapResScopedDimensionProperty property;
            final /* synthetic */ Impl this$0;

            public XmlaRowSetColumn(Impl impl, OlapLevel level, OlapResScopedDimensionProperty property) {
                Impl impl2 = impl;
                Objects.requireNonNull(impl2);
                this.this$0 = impl2;
                this.level = level;
                this.property = property;
            }

            @Override
            public String getTitle(OlapNameContext nameContext) {
                return this.level.getUniqueName(nameContext) + ".[" + this.property.getName() + "]";
            }

            @Override
            public CdXmlaSchemaType getType() {
                return CdXmlaSchemaType.DBTYPE_WSTR;
            }

            @Override
            public XmlaPropertyValue getValue(OlapTuple rowMember, OlapTuple colMember, OlapResCell cell) {
                if (rowMember == null) {
                    return new XmlaPropertyValue((OlapScalarEntity)OlapEmptyEntity.INSTANCE);
                }
                OlapMember levelMember = rowMember.getMemberAtLevel(this.level);
                if (levelMember == null) {
                    return new XmlaPropertyValue((OlapScalarEntity)OlapEmptyEntity.INSTANCE);
                }
                XmlaPropertyValue propValue = rowMember.isMember() && OlapMember.equal((OlapMember)levelMember, (OlapMember)rowMember.getMember(0)) ? this.getPropertyValue(levelMember) : new XmlaPropertyValue(this.property.eval(this.this$0.context, levelMember));
                if (propValue == null) {
                    return new XmlaPropertyValue((OlapScalarEntity)OlapEmptyEntity.INSTANCE);
                }
                return propValue;
            }

            @Nullable
            private XmlaPropertyValue getPropertyValue(OlapMember member) {
                OlapMemberPropertyValues values = this.this$0.memberPropertyValues.get(member);
                if (values == null) {
                    return null;
                }
                if (this.property.isCaption()) {
                    String caption = this.this$0.nameContext.getCaption(values);
                    return new XmlaPropertyValue((OlapScalarEntity)new OlapStringEntity(caption));
                }
                List mproperties = values.getProperties();
                for (int idx = 0; idx < mproperties.size(); ++idx) {
                    OlapResScopedDimensionProperty mproperty = (OlapResScopedDimensionProperty)mproperties.get(idx);
                    if (!this.property.equals(mproperty)) continue;
                    XmlaPropertyValue value = new XmlaPropertyValue((OlapScalarEntity)values.getValues().get(idx));
                    return value;
                }
                return null;
            }
        }

        private static class XmlaRowSetColumnValue
        implements IXmlaRowSetColumn {
            private final OlapTuple tuple;

            public XmlaRowSetColumnValue(OlapTuple tuple) {
                this.tuple = tuple;
            }

            @Override
            public String getTitle(OlapNameContext nameContext) {
                StringBuffer title = new StringBuffer();
                for (int i = 0; i < this.tuple.getMemberCount(); ++i) {
                    if (i != 0) {
                        title.append(".");
                    }
                    OlapMember members = this.tuple.getMember(i);
                    title.append(members.getUniqueName(nameContext));
                }
                return title.toString();
            }

            @Override
            public CdXmlaSchemaType getType() {
                return CdXmlaSchemaType.DBTYPE_VARIANT;
            }

            @Override
            public XmlaPropertyValue getValue(OlapTuple rowMember, OlapTuple colMember, OlapResCell cell) {
                return new XmlaPropertyValue(cell.getRequestPropertyValue(OlapIntrinsicCellProperties.VALUE));
            }
        }

        private static interface IXmlaRowSetColumn {
            public XmlaPropertyValue getValue(OlapTuple var1, OlapTuple var2, OlapResCell var3);

            public String getTitle(OlapNameContext var1);

            public CdXmlaSchemaType getType();
        }
    }

    private static class DataRowClone
    implements IXmlaRowSetDataRow {
        private final List<IXmlaPropertyValue> properties;
        private final List<String> names;

        private DataRowClone(IXmlaRowSetDataRow copy) {
            this.properties = new ArrayList<IXmlaPropertyValue>(copy.size());
            this.names = new ArrayList<String>(copy.size());
            for (int i = 0; i < copy.size(); ++i) {
                this.properties.add(copy.get(i));
                this.names.add(copy.getXmlElementName(i));
            }
        }

        public int size() {
            return this.names.size();
        }

        public IXmlaPropertyValue get(int col) {
            return this.properties.get(col);
        }

        public String getXmlElementName(int col) {
            return this.names.get(col);
        }
    }
}

