/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.rowset;

import crazydev.xmla.model.annotation.XmlaAnCardinality;
import crazydev.xmla.model.annotation.XmlaAnDefs;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.discover.IXmlaMDSchemaMember;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberProperties;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberProperty;
import crazydev.xmla.model.discover.bean.XmlaMDSchemaMemberPropertyValue;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.types.XmlaHChapterElement;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowSetColumn;
import crazydev.xmla.server.iccube.rowset.XmlaDiscoverRowSet;
import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class XmlaDiscoverRowSetMultipleColumn
implements IXmlaDiscoverRowSetColumn {
    private final XmlaDiscoverRowSet owner;
    private final XmlaAnDefs column;
    private final Method javaMethod;

    public XmlaDiscoverRowSetMultipleColumn(XmlaDiscoverRowSet owner, XmlaAnDefs column, Method javaMethod) {
        this.owner = owner;
        this.column = column;
        this.javaMethod = javaMethod;
    }

    @Override
    public String getName() {
        return "XmlaDiscoverRowSetMultipleColumn";
    }

    @Override
    public int getPosition() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void emitXmlSchema(XmlaSerializer serializer, @Nullable IXmlaDiscover item) throws SAXException {
        if (item instanceof IXmlaMDSchemaMember) {
            IXmlaMDSchemaMember member = (IXmlaMDSchemaMember)item;
            XmlaMDSchemaMemberProperties properties = member.getProperties();
            if (properties == null) {
                return;
            }
            List propertyDefinitions = properties.getProperties();
            for (XmlaMDSchemaMemberProperty definition : propertyDefinitions) {
                if (this.isInvalidProperty(definition)) continue;
                serializer.addXmlaSchemaElement("xsd:element", definition.getName(), definition.getType(), XmlaAnCardinality.ZERO_OR_ONE, true);
            }
        }
    }

    @Override
    public void emitData(XmlaSerializer serializer, IXmlaDiscover item) throws SAXException {
        if (item instanceof IXmlaMDSchemaMember) {
            IXmlaMDSchemaMember member = (IXmlaMDSchemaMember)item;
            XmlaMDSchemaMemberProperties properties = member.getProperties();
            if (properties == null) {
                return;
            }
            List propertyDefinitions = properties.getProperties();
            List propertyValues = properties.getValues();
            for (int ii = 0; ii < propertyDefinitions.size(); ++ii) {
                XmlaMDSchemaMemberProperty definition = (XmlaMDSchemaMemberProperty)propertyDefinitions.get(ii);
                if (this.isInvalidProperty(definition)) continue;
                String tag = definition.getName();
                XmlaMDSchemaMemberPropertyValue value = (XmlaMDSchemaMemberPropertyValue)propertyValues.get(ii);
                if (value == null || value.isMdxNull()) continue;
                serializer.startElement(null, null, tag, null);
                char[] xvalue = value.asString().toCharArray();
                serializer.characters(xvalue, 0, xvalue.length);
                serializer.endElement(null, null, tag);
            }
        }
    }

    private boolean isInvalidProperty(XmlaMDSchemaMemberProperty definition) {
        return !definition.isValid() || this.owner.getColumnByName(definition.getName()) != null;
    }

    @Override
    public void checkConsistency() {
    }

    @Override
    public boolean isNotRestrictable() {
        return true;
    }

    @Override
    public boolean restrictionMatches(IXmlaDiscover row, String restrictionValue) {
        return false;
    }

    @Override
    public boolean isTrue(IXmlaDiscover row) {
        return true;
    }

    @Override
    @Nullable
    public XmlaHChapterElement getRestrictionChapter() {
        return null;
    }
}

