/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.rowset;

import crazydev.common.exception.CdRuntimeException;
import crazydev.xmla.model.annotation.XmlaAnDiscoverType;
import crazydev.xmla.model.discover.IXmlaDiscover;
import crazydev.xmla.model.message.XmlaRestriction;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowColumn;
import crazydev.xmla.server.iccube.rowset.IXmlaDiscoverRowSetColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class XmlaDiscoverRowSet {
    private final List<IXmlaDiscoverRowSetColumn> rows = new ArrayList<IXmlaDiscoverRowSetColumn>();
    private final List<IXmlaDiscoverRowSetColumn> sortedColumns = new ArrayList<IXmlaDiscoverRowSetColumn>();
    private final Class<? extends IXmlaDiscover> type;
    private final XmlaAnDiscoverType xmlaClazzAn;

    public XmlaDiscoverRowSet(Class<? extends IXmlaDiscover> type, XmlaAnDiscoverType xmlaClazzAn) {
        this.type = type;
        this.xmlaClazzAn = xmlaClazzAn;
    }

    public XmlaDiscoverRowSet filter(List<String> fields) {
        ArrayList<IXmlaDiscoverRowSetColumn> rowsF = new ArrayList<IXmlaDiscoverRowSetColumn>();
        for (String field : fields) {
            rowsF.add(this.getForName(field));
        }
        XmlaDiscoverRowSet thisF = new XmlaDiscoverRowSet(this.type, this.xmlaClazzAn);
        thisF.rows.addAll(rowsF);
        thisF.sortedColumns.addAll(this.rows);
        return thisF;
    }

    public void add(IXmlaDiscoverRowSetColumn rowColumn) {
        this.rows.add(rowColumn);
    }

    public void onFinish() {
        Collections.sort(this.rows, new Comparator<IXmlaDiscoverRowSetColumn>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(IXmlaDiscoverRowSetColumn o1, IXmlaDiscoverRowSetColumn o2) {
                return o1.getPosition() < o2.getPosition() ? -1 : (o1.getPosition() == o2.getPosition() ? 0 : 1);
            }
        });
    }

    public Class<? extends IXmlaDiscover> getType() {
        return this.type;
    }

    public XmlaAnDiscoverType getXmlaClazz() {
        return this.xmlaClazzAn;
    }

    public List<IXmlaDiscoverRowSetColumn> getList() {
        return this.rows;
    }

    public List<IXmlaDiscoverRowSetColumn> getSortedColumns() {
        return this.sortedColumns;
    }

    @Nullable
    public IXmlaDiscoverRowColumn getColumn(XmlaRestriction restriction) {
        String name = restriction.getName();
        return this.getForName(name);
    }

    @Nullable
    private IXmlaDiscoverRowSetColumn getForName(String name) {
        for (IXmlaDiscoverRowSetColumn column : this.rows) {
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    public void addSortedColumn(String columnName) {
        IXmlaDiscoverRowSetColumn column = this.getForName(columnName);
        if (column == null) {
            throw new CdRuntimeException("Unable to find restriction [" + columnName + " ] in interface [" + String.valueOf(this.type) + "]");
        }
        this.sortedColumns.add(column);
    }

    @Nullable
    public IXmlaDiscoverRowSetColumn getColumnByName(String columnName) {
        for (IXmlaDiscoverRowSetColumn row : this.rows) {
            if (!row.getName().equals(columnName)) continue;
            return row;
        }
        return null;
    }
}

