/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.iccube.olap.entity.result.OlapResScopedDimensionProperty;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.xmla.server.iccube.mddataset.XmlaDimensionProperty;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.ArrayList;
import java.util.List;

public class XmlaMemberPropertyValues {
    private final String caption;
    private final List<XmlaDimensionProperty> properties = new ArrayList<XmlaDimensionProperty>();
    private final List<XmlaPropertyValue> values = new ArrayList<XmlaPropertyValue>();

    public XmlaMemberPropertyValues(String memberHierarchyUniqueName, String memberLevelUniqueName, int memberLevelNumber, String memberUniqueName, String memberCaption) {
        this.caption = memberCaption;
        this.addMandatoryStuff(memberHierarchyUniqueName, memberLevelUniqueName, memberLevelNumber, memberUniqueName, memberCaption);
    }

    public XmlaMemberPropertyValues(OlapMember member, OlapNameContext nameContext, int displayInfo, OlapMemberPropertyValues properties) {
        this.caption = nameContext.getCaption(properties);
        this.addMandatoryStuff(nameContext, member, displayInfo, properties);
        for (OlapResScopedDimensionProperty icCubeProperty : properties.getProperties()) {
            this.properties.add(new XmlaDimensionProperty(nameContext, icCubeProperty));
        }
        for (OlapScalarEntity icCubePropertyValue : properties.getValues()) {
            this.values.add(new XmlaPropertyValue(icCubePropertyValue));
        }
    }

    private void addMandatoryStuff(String memberHierarchyUniqueName, String memberLevelUniqueName, int memberLevelNumber, String memberUniqueName, String memberCaption) {
        String hierarchyUniqueName = memberHierarchyUniqueName;
        this.addMandatoryStuff(hierarchyUniqueName, "UName", "MEMBER_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, memberUniqueName);
        this.addMandatoryStuff(hierarchyUniqueName, "Caption", "MEMBER_CAPTION", CdXmlaSchemaType.DBTYPE_WSTR, memberCaption);
        this.addMandatoryStuff(hierarchyUniqueName, "LName", "LEVEL_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, memberLevelUniqueName);
        this.addMandatoryStuff(hierarchyUniqueName, "LNum", "LEVEL_NUMBER", CdXmlaSchemaType.DBTYPE_I4, String.valueOf(memberLevelNumber));
        this.addMandatoryStuff(hierarchyUniqueName, "DisplayInfo", "DISPLAY_INFO", CdXmlaSchemaType.DBTYPE_UI4, "");
    }

    private void addMandatoryStuff(OlapNameContext nameContext, OlapMember member, int displayInfo, OlapMemberPropertyValues properties) {
        String hierarchyUniqueName = member.getHierarchy().getUniqueName(nameContext);
        this.addMandatoryStuff(hierarchyUniqueName, "UName", "MEMBER_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, member.getUniqueName(nameContext));
        this.addMandatoryStuff(hierarchyUniqueName, "Caption", "MEMBER_CAPTION", CdXmlaSchemaType.DBTYPE_WSTR, nameContext.getCaption(properties));
        this.addMandatoryStuff(hierarchyUniqueName, "LName", "LEVEL_UNIQUE_NAME", CdXmlaSchemaType.DBTYPE_WSTR, member.getLevel().getUniqueName(nameContext));
        this.addMandatoryStuff(hierarchyUniqueName, "LNum", "LEVEL_NUMBER", CdXmlaSchemaType.DBTYPE_I4, String.valueOf(member.getLevel().getLevelNumber()));
        this.addMandatoryStuff(hierarchyUniqueName, "DisplayInfo", "DISPLAY_INFO", CdXmlaSchemaType.DBTYPE_UI4, String.valueOf(displayInfo));
    }

    private void addMandatoryStuff(String memberHierarchyUniqueName, String xmlaName, String name, CdXmlaSchemaType xmlaType, String value) {
        this.properties.add(new XmlaDimensionProperty(xmlaName, memberHierarchyUniqueName + ".[" + name + "]", xmlaType, name, false, name.equals("MEMBER_CAPTION"), false));
        this.values.add(new XmlaPropertyValue(false, xmlaType, value));
    }

    public String getCaption() {
        return this.caption;
    }

    public List<XmlaDimensionProperty> getProperties() {
        return this.properties;
    }

    public List<XmlaPropertyValue> getValues() {
        return this.values;
    }
}

