/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyValues;
import crazydev.xmla.model.mddataset.IXmlaMember;
import crazydev.xmla.server.iccube.mddataset.XmlaDimensionProperty;
import crazydev.xmla.server.iccube.mddataset.XmlaMemberPropertyValues;
import crazydev.xmla.server.iccube.mddataset.XmlaPropertyValue;
import java.util.List;

public class XmlaMember
implements IXmlaMember {
    private final String memberHierarchyUniqueName;
    private final String memberUniqueName;
    private final String memberLevelUniqueName;
    private final int memberLevelNumber;
    private final int displayInfo;
    private final XmlaMemberPropertyValues propertyValues;

    public XmlaMember(OlapNameContext nameContext, OlapMember member, int displayInfo, OlapMemberPropertyValues propertyValues) {
        this.memberHierarchyUniqueName = member.getHierarchy().getUniqueName(nameContext);
        this.memberUniqueName = member.getUniqueName(nameContext);
        this.memberLevelUniqueName = member.getLevel().getUniqueName(nameContext);
        this.memberLevelNumber = member.getLevel().getLevelNumber();
        this.displayInfo = displayInfo;
        this.propertyValues = new XmlaMemberPropertyValues(member, nameContext, displayInfo, propertyValues);
    }

    public String getHierarchyUniqueName() {
        return this.memberHierarchyUniqueName;
    }

    public String getUniqueName() {
        return this.memberUniqueName;
    }

    public String getCaption() {
        return this.propertyValues.getCaption();
    }

    public String getLevelUniqueName() {
        return this.memberLevelUniqueName;
    }

    public int getLevelNumber() {
        return this.memberLevelNumber;
    }

    public String getDisplayInfo() {
        return String.valueOf(this.displayInfo);
    }

    public List<XmlaDimensionProperty> getProperties() {
        return this.propertyValues.getProperties();
    }

    public List<XmlaPropertyValue> getValues() {
        return this.propertyValues.getValues();
    }
}

