/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.lang.CdXmlaSchemaType;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.olap.entity.scalar.OlapErrorEntity;
import crazydev.xmla.model.mddataset.IXmlaAxis;
import crazydev.xmla.model.mddataset.IXmlaAxisInfo;
import crazydev.xmla.model.mddataset.IXmlaCell;
import crazydev.xmla.model.mddataset.IXmlaCellData;
import crazydev.xmla.model.mddataset.IXmlaCellInfo;
import crazydev.xmla.model.mddataset.IXmlaCellProperty;
import crazydev.xmla.model.mddataset.IXmlaCube;
import crazydev.xmla.model.mddataset.IXmlaDimensionProperty;
import crazydev.xmla.model.mddataset.IXmlaError;
import crazydev.xmla.model.mddataset.IXmlaHierarchyInfo;
import crazydev.xmla.model.mddataset.IXmlaMDDataSet;
import crazydev.xmla.model.mddataset.IXmlaMember;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.mddataset.IXmlaTuple;
import crazydev.xmla.model.mddataset.IXmlaTuples;
import crazydev.xmla.model.message.XmlaSerializer;
import crazydev.xmla.model.rowset.IXmlaRowSet;
import crazydev.xmla.model.rowset.IXmlaRowSetDataRow;
import crazydev.xmla.server.iccube.mddataset.XmlaDimensionProperty;
import crazydev.xmla.server.iccube.mddataset.XmlaError;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlaDataSetSerializer {
    public void streamRowSet(XmlaSerializer serializer, IXmlaRowSet result) throws SAXException {
        IXmlaRowSetDataRow titleRow = result.getTitle();
        for (IXmlaRowSetDataRow dataRow : result.getRows()) {
            serializer.startElement(null, null, "row", null);
            for (int colPos = 0; colPos < dataRow.size(); ++colPos) {
                IXmlaPropertyValue rowCell = dataRow.get(colPos);
                String xmlElementName = titleRow.getXmlElementName(colPos);
                XmlaDataSetSerializer.doStreamCellProperty(serializer, rowCell, xmlElementName);
            }
            serializer.endElement(null, null, "row");
        }
    }

    public void streamMDDataSet(XmlaSerializer serializer, IXmlaMDDataSet dataset) throws SAXException {
        serializer.startElement(null, null, "OlapInfo", null);
        XmlaDataSetSerializer.doStreamCubeInfo(serializer, dataset);
        XmlaDataSetSerializer.doStreamAxesInfo(serializer, dataset);
        XmlaDataSetSerializer.doStreamCellInfo(serializer, dataset);
        serializer.endElement(null, null, "OlapInfo");
        XmlaDataSetSerializer.doStreamAxes(serializer, dataset);
        XmlaDataSetSerializer.doStreamCellData(serializer, dataset);
    }

    private static void doStreamCubeInfo(XmlaSerializer serializer, IXmlaMDDataSet dataset) throws SAXException {
        serializer.startElement(null, null, "CubeInfo", null);
        List cubes = dataset.getOlapInfo().getCubeInfo().getCubes();
        for (IXmlaCube cube : cubes) {
            serializer.startElement(null, null, "Cube", null);
            serializer.startElement(null, null, "CubeName", null);
            String value = cube.getName();
            serializer.characters(value.toCharArray(), 0, value.length());
            serializer.endElement(null, null, "CubeName");
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, null, "xmlns", "string", "http://schemas.microsoft.com/analysisservices/2003/engine");
            Date when = cube.getLastUpdate();
            String lastUpdate = new SimpleDateFormat("yyyy-MM-dd").format(when) + "T" + new SimpleDateFormat("HH:mm:ss").format(when);
            serializer.startElement(null, null, "LastDataUpdate", (Attributes)attrs);
            serializer.characters(lastUpdate.toCharArray(), 0, lastUpdate.length());
            serializer.endElement(null, null, "LastDataUpdate");
            serializer.startElement(null, null, "LastSchemaUpdate", (Attributes)attrs);
            serializer.characters(lastUpdate.toCharArray(), 0, lastUpdate.length());
            serializer.endElement(null, null, "LastSchemaUpdate");
            serializer.endElement(null, null, "Cube");
        }
        serializer.endElement(null, null, "CubeInfo");
    }

    private static void doStreamAxesInfo(XmlaSerializer serializer, IXmlaMDDataSet dataset) throws SAXException {
        serializer.startElement(null, null, "AxesInfo", null);
        for (IXmlaAxisInfo axis : dataset.getOlapInfo().getAxesInfo().getAxisInfo()) {
            AttributesImpl axisAttrs = new AttributesImpl();
            axisAttrs.addAttribute(null, null, "name", "string", axis.getName());
            serializer.startElement(null, null, "AxisInfo", (Attributes)axisAttrs);
            for (IXmlaHierarchyInfo hierarchyInfo : axis.getHierarchyInfo()) {
                String hierarchyUniqueName = hierarchyInfo.getUniqueName();
                AttributesImpl hierarchyAttrs = new AttributesImpl();
                hierarchyAttrs.addAttribute(null, null, "name", "string", hierarchyUniqueName);
                serializer.startElement(null, null, "HierarchyInfo", (Attributes)hierarchyAttrs);
                for (IXmlaDimensionProperty property : hierarchyInfo.getProperties()) {
                    String xmlaName = property.getXmlaName();
                    CdXmlaSchemaType xmlaType = property.getXmlaType();
                    String xmlaScopedName = property.getXmlaScopedUniqueName();
                    Object xmlaScopedNameX = !xmlaScopedName.contains("].[") ? hierarchyInfo.getUniqueName() + "." + xmlaScopedName : xmlaScopedName;
                    if (property instanceof XmlaDimensionProperty) {
                        XmlaDimensionProperty xproperty = (XmlaDimensionProperty)property;
                        serializer.addXmlaSchemaElement(xmlaName, (String)xmlaScopedNameX, xproperty.isUserDefined() ? null : xmlaType);
                        continue;
                    }
                    serializer.addXmlaSchemaElement(xmlaName, (String)xmlaScopedNameX, xmlaType);
                }
                serializer.endElement(null, null, "HierarchyInfo");
            }
            serializer.endElement(null, null, "AxisInfo");
        }
        serializer.endElement(null, null, "AxesInfo");
    }

    private static void doStreamCellInfo(XmlaSerializer serializer, IXmlaMDDataSet dataset) throws SAXException {
        serializer.startElement(null, null, "CellInfo", null);
        IXmlaCellInfo cellInfo = dataset.getOlapInfo().getCellInfo();
        List properties = cellInfo.getCellProperties();
        for (IXmlaCellProperty cellProperty : properties) {
            serializer.addXmlaSchemaElement(cellProperty.getXmlaName(), cellProperty.getName(), cellProperty.getXmlaType());
        }
        serializer.endElement(null, null, "CellInfo");
    }

    private static void doStreamAxes(XmlaSerializer serializer, IXmlaMDDataSet dataset) throws SAXException {
        serializer.startElement(null, null, "Axes", null);
        for (IXmlaAxis axis : dataset.getAxes().getAxes()) {
            AttributesImpl axisAttrs = new AttributesImpl();
            axisAttrs.addAttribute(null, null, "name", "string", axis.getName());
            serializer.startElement(null, null, "Axis", (Attributes)axisAttrs);
            XmlaDataSetSerializer.doStreamTuples(serializer, axis);
            serializer.endElement(null, null, "Axis");
        }
        serializer.endElement(null, null, "Axes");
    }

    private static void doStreamTuples(XmlaSerializer serializer, IXmlaAxis axis) throws SAXException {
        serializer.startElement(null, null, "Tuples", null);
        if (axis.hasTuples()) {
            IXmlaTuples axisTuples = axis.getTuples();
            for (IXmlaTuple tuple : axisTuples.getTuples()) {
                serializer.startElement(null, null, "Tuple", null);
                for (int idx = 0; idx < tuple.getMembers().size(); ++idx) {
                    IXmlaMember member = (IXmlaMember)tuple.getMembers().get(idx);
                    AttributesImpl memberAttrs = new AttributesImpl();
                    memberAttrs.addAttribute(null, null, "Hierarchy", "string", member.getHierarchyUniqueName());
                    serializer.startElement(null, null, "Member", (Attributes)memberAttrs);
                    List memberProperties = member.getProperties();
                    for (int propertyIdx = 0; propertyIdx < memberProperties.size(); ++propertyIdx) {
                        String name;
                        IXmlaDimensionProperty property = (IXmlaDimensionProperty)memberProperties.get(propertyIdx);
                        IXmlaPropertyValue value = (IXmlaPropertyValue)member.getValues().get(propertyIdx);
                        if (!value.isMdxNull()) {
                            name = property.getXmlaName();
                            String svalue = value.asString();
                            CdXmlaSchemaType xmlaType = property.getXmlaType();
                            if (property instanceof XmlaDimensionProperty && !xmlaType.equals((Object)CdXmlaSchemaType.DBTYPE_WSTR)) {
                                AttributesImpl attrs;
                                XmlaDimensionProperty xproperty = (XmlaDimensionProperty)property;
                                if (xproperty.isUserDefined()) {
                                    attrs = new AttributesImpl();
                                    attrs.addAttribute(null, null, "type", "string", XmlaSerializer.toXsdString((CdXmlaSchemaType)xmlaType));
                                } else {
                                    attrs = null;
                                }
                                serializer.startElement(null, null, name, (Attributes)attrs);
                                serializer.characters(svalue.toCharArray(), 0, svalue.length());
                                serializer.endElement(null, null, name);
                                continue;
                            }
                            serializer.addElement(name, svalue);
                            continue;
                        }
                        if (!property.isKey()) continue;
                        name = property.getXmlaName();
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addAttribute(null, null, "xsi:nil", "string", "true");
                        serializer.startElement(null, null, name, (Attributes)attrs);
                        serializer.endElement(null, null, name);
                    }
                    serializer.endElement(null, null, "Member");
                }
                serializer.endElement(null, null, "Tuple");
            }
        }
        serializer.endElement(null, null, "Tuples");
    }

    private static void doStreamCellData(XmlaSerializer serializer, IXmlaMDDataSet dataset) throws SAXException {
        serializer.startElement(null, null, "CellData", null);
        IXmlaCellInfo cellInfo = dataset.getOlapInfo().getCellInfo();
        List requestedProperties = cellInfo.getCellProperties();
        if (requestedProperties.size() != 1 || !((IXmlaCellProperty)requestedProperties.get(0)).isCellOrdinal()) {
            XmlaDataSetSerializer.doStreamCellDataX(serializer, dataset);
        }
        serializer.endElement(null, null, "CellData");
    }

    private static void doStreamCellDataX(XmlaSerializer serializer, IXmlaMDDataSet dataset) throws SAXException {
        IXmlaCellInfo cellInfo = dataset.getOlapInfo().getCellInfo();
        List requestedProperties = cellInfo.getCellProperties();
        IXmlaCellData cellData = dataset.getCellData();
        int maxOrdinal = cellData.getMaxOrdinal();
        for (int ordinal = 0; ordinal <= maxOrdinal; ++ordinal) {
            IXmlaCell cell = cellData.getCellByOrdinal(ordinal);
            if (cell == null) continue;
            AttributesImpl cellAttrs = new AttributesImpl();
            cellAttrs.addAttribute(null, null, "CellOrdinal", "string", String.valueOf(cell.getOrdinal()));
            if (XmlaDataSetSerializer.isVoidCell(requestedProperties, cell)) continue;
            XmlaDataSetSerializer.doStreamCell(serializer, cellAttrs, requestedProperties, cell);
        }
    }

    private static void doStreamCell(XmlaSerializer serializer, AttributesImpl cellAttrs, List<? extends IXmlaCellProperty> properties, IXmlaCell cell) throws SAXException {
        serializer.startElement(null, null, "Cell", (Attributes)cellAttrs);
        for (int idx = 0; idx < properties.size(); ++idx) {
            IXmlaCellProperty property = properties.get(idx);
            if (property.isCellOrdinal()) continue;
            if (cell.isOnError() && (property.isValue() || property.isFormattedValue())) {
                XmlaDataSetSerializer.doStreamCellPropertyOnError(serializer, property.getXmlaName(), cell.getError());
                continue;
            }
            IXmlaPropertyValue value = cell.getPropertyValue(idx);
            if (value.isMdxNull()) continue;
            XmlaDataSetSerializer.doStreamCellProperty(serializer, value, property.getXmlaName());
        }
        serializer.endElement(null, null, "Cell");
    }

    private static void doStreamCellProperty(XmlaSerializer serializer, IXmlaPropertyValue pValue, String elementName) throws SAXException {
        if (pValue.getXmlaType() != CdXmlaSchemaType.DBTYPE_ERROR) {
            XmlaDataSetSerializer.doStreamCellPropertyOk(serializer, elementName, pValue);
        } else {
            OlapException error = ((OlapErrorEntity)pValue).error();
            XmlaDataSetSerializer.doStreamCellPropertyOnError(serializer, elementName, new XmlaError(error));
        }
    }

    private static void doStreamCellPropertyOk(XmlaSerializer serializer, String elementName, IXmlaPropertyValue pValue) throws SAXException {
        CdXmlaSchemaType xtype = pValue.getXmlaType();
        if (xtype != CdXmlaSchemaType.DBTYPE_NULL && xtype != CdXmlaSchemaType.DBTYPE_EMPTY) {
            AttributesImpl valueAttrs = new AttributesImpl();
            if (xtype != null && xtype != CdXmlaSchemaType.DBTYPE_WSTR) {
                valueAttrs.addAttribute(null, null, "xsi:type", "string", XmlaSerializer.toXsdString((CdXmlaSchemaType)xtype));
            }
            String value = pValue.asString();
            serializer.startElement(null, null, elementName, (Attributes)valueAttrs);
            serializer.characters(value.toCharArray(), 0, value.length());
            serializer.endElement(null, null, elementName);
        }
    }

    private static void doStreamCellPropertyOnError(XmlaSerializer serializer, String elementName, IXmlaError error) throws SAXException {
        Object code;
        serializer.startElement(null, null, elementName, null);
        serializer.startElement(null, null, "Error", null);
        if (error instanceof XmlaError) {
            CdErrorCode errorCode = ((XmlaError)error).getErrorCode();
            code = "" + errorCode.getNumericalValue();
        } else {
            code = error.getCode();
        }
        String description = error.getDescription();
        serializer.addElement("ErrorCode", (String)code);
        serializer.addElement("Description", description == null ? "not-available" : description);
        serializer.endElement(null, null, "Error");
        serializer.endElement(null, null, elementName);
    }

    private static boolean isVoidCell(List<? extends IXmlaCellProperty> properties, IXmlaCell cell) {
        for (int pos = 0; pos < properties.size(); ++pos) {
            IXmlaCellProperty property = properties.get(pos);
            if (property.isCellOrdinal()) continue;
            IXmlaPropertyValue value = cell.getPropertyValue(pos);
            if (value != null && !value.isMdxNull() && value.getXmlaType() != CdXmlaSchemaType.DBTYPE_NULL && value.getXmlaType() != CdXmlaSchemaType.DBTYPE_EMPTY) {
                return false;
            }
            if (!cell.isOnError() || !property.isValue() && !property.isFormattedValue()) continue;
            return false;
        }
        return true;
    }
}

