/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.common.lang.CdXmlaOptions;
import crazydev.common.xmla.CdXmlaCellOrdinalHelper;
import crazydev.iccube.olap.entity.properties.cell.OlapCellProperty;
import crazydev.iccube.olap.entity.result.OlapResCellData;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSet;
import crazydev.xmla.model.mddataset.IXmlaCellData;
import crazydev.xmla.server.iccube.mddataset.XmlaCell;
import crazydev.xmla.server.iccube.mddataset.XmlaCellProperty;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaCellData
implements IXmlaCellData {
    private final CdXmlaCellOrdinalHelper helper;
    private final int maxOrdinal;
    private final XmlaCell[] cells;
    private final List<XmlaCellProperty> requestedProperties = new ArrayList<XmlaCellProperty>();

    public XmlaCellData(@Nullable CdXmlaOptions options, OlapResSelectStatementDataSet result) {
        OlapResCellData resultCells = result.getCells();
        List icCubeRequestedProperties = resultCells.getRequestedProperties();
        for (OlapCellProperty icCubeRequestedProperty : icCubeRequestedProperties) {
            this.requestedProperties.add(new XmlaCellProperty(icCubeRequestedProperty));
        }
        this.helper = resultCells.getOrdinals();
        this.maxOrdinal = resultCells.getMaxOrdinal();
        this.cells = new XmlaCell[this.maxOrdinal + 1];
        for (int ii = 0; ii < this.cells.length; ++ii) {
            this.cells[ii] = new XmlaCell(options, this.requestedProperties, resultCells.getCell(ii));
        }
    }

    public int getMaxOrdinal() {
        return this.maxOrdinal;
    }

    @Nullable
    public XmlaCell getCellByOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal > this.getMaxOrdinal()) {
            throw new IllegalArgumentException("Wrong ordinal [" + ordinal + "] (range:0:" + this.getMaxOrdinal() + ")");
        }
        return this.cells[ordinal];
    }

    @Nullable
    public XmlaCell getCell(int ... Si) {
        int ordinal = this.helper.computeCellOrdinal(Si);
        return this.getCellByOrdinal(ordinal);
    }

    public List<XmlaCellProperty> getCellProperties() {
        return this.requestedProperties;
    }
}

