/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.server.iccube.mddataset;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.OlapResAxis;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.xmla.model.mddataset.IXmlaAxisInfo;
import crazydev.xmla.server.iccube.mddataset.XmlaHierarchyInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaAxisInfo
implements IXmlaAxisInfo {
    private final List<XmlaHierarchyInfo> hierarchyInfos = new ArrayList<XmlaHierarchyInfo>();
    private final String axisName;

    public XmlaAxisInfo(OlapNameContext nameContext, OlapResAxis axis) {
        this.axisName = axis.getName().getXmlaName();
        OlapTuple anyTuple = axis.getAnyTuple();
        if (anyTuple != null) {
            for (int i = 0; i < anyTuple.getMemberCount(); ++i) {
                OlapMember member = anyTuple.getMember(i);
                this.hierarchyInfos.add(new XmlaHierarchyInfo(nameContext, axis.getRequestedProperties(), member.getHierarchy()));
            }
        }
    }

    public XmlaAxisInfo(OlapNameContext nameContext, @Nullable OlapTuple tuple) {
        this.axisName = "SlicerAxis";
        for (int idx = 0; tuple != null && idx < tuple.getMemberCount(); ++idx) {
            OlapMember member = tuple.getMember(idx);
            this.hierarchyInfos.add(new XmlaHierarchyInfo(nameContext, member.getHierarchy()));
        }
    }

    public List<XmlaHierarchyInfo> getHierarchyInfo() {
        return this.hierarchyInfos;
    }

    public boolean isEmpty() {
        return this.hierarchyInfos.isEmpty();
    }

    public String getName() {
        return this.axisName;
    }
}

