/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.searchconsole.datasource;

import com.google.api.services.searchconsole.v1.SearchConsole;
import com.google.api.services.searchconsole.v1.model.ApiDataRow;
import com.google.api.services.searchconsole.v1.model.SearchAnalyticsQueryRequest;
import com.google.api.services.searchconsole.v1.model.SearchAnalyticsQueryResponse;
import crazydev.common.collection.CdCollections;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.googleapi.OlapBuilderGoogleCommon;
import crazydev.iccube.builder.googleapi.searchconsole.datasource.OlapBuilderGoogleSearchConsole4DataTable;
import crazydev.iccube.builder.googleapi.searchconsole.datasource.OlapBuilderGoogleSearchConsoleConnection;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OlapBuilderGoogleSearchConsole4RowReader
extends OlapBuilderAbstractTableRowReader<OlapBuilderGoogleSearchConsole4DataTable, OlapBuilderGoogleSearchConsoleConnection> {
    private static final Map<Integer, DateTimeFormatter> formatters = new HashMap<Integer, DateTimeFormatter>();
    private List<ApiDataRow> rows;
    private int offset = 0;
    private final Map<IOlapBuilderDataColumnDef, Integer> colMapper = new HashMap<IOlapBuilderDataColumnDef, Integer>();
    private int i = -1;
    private LocalDate startDate;

    protected OlapBuilderGoogleSearchConsole4RowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderGoogleSearchConsole4DataTable dataTable) {
        super(context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)dataTable, dataTable.getName());
    }

    public void doInit() {
        this.initConnection();
        this.offset = 0;
        this.colMapper.clear();
        this.startDate = ((OlapBuilderGoogleSearchConsole4DataTable)this.table).getTypedDS().getStartDate();
        this.startDate = this.startDate == null ? new LocalDate().minusMonths(1) : this.startDate;
        int idx = 0;
        for (IOlapBuilderDataColumnDef column : ((OlapBuilderGoogleSearchConsole4DataTable)this.table).getAllColumns()) {
            if (column.getTableType() == null || !column.getTableType().startsWith("D-")) continue;
            this.colMapper.put(column, idx++);
        }
    }

    public void done() {
        super.done();
    }

    public boolean isRowSafe() {
        return true;
    }

    private void loadPage(OlapRuntimeContext context) {
        this.rows = Collections.EMPTY_LIST;
        SearchAnalyticsQueryRequest request = ((OlapBuilderGoogleSearchConsole4DataTable)this.table).buildRequest(this.startDate);
        if (request == null) {
            return;
        }
        this.startDate = OlapBuilderGoogleCommon.format.parseLocalDate(request.getEndDate()).plusDays(1);
        try {
            SearchConsole searchConsole = ((OlapBuilderGoogleSearchConsoleConnection)this.connection).getSearchConsole(context);
            SearchAnalyticsQueryResponse response = (SearchAnalyticsQueryResponse)searchConsole.searchanalytics().query(((OlapBuilderGoogleSearchConsole4DataTable)this.table).getTypedDS().getDomain(), request).execute();
            this.rows = response.getRows();
            this.rows = this.rows == null ? Collections.EMPTY_LIST : this.rows;
            this.i = 0;
        }
        catch (IOException e) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.IO_ERROR, new Serializable[]{e});
        }
    }

    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        if (this.i == -1) {
            this.loadPage(this.context.asRuntimeContext());
        }
        if (this.i >= this.rows.size()) {
            this.loadPage(this.context.asRuntimeContext());
        }
        if (this.rows.isEmpty()) {
            return null;
        }
        final ApiDataRow row = this.rows.get(this.i++);
        return new OlapBuilderAbstractTableRow(this){
            final /* synthetic */ OlapBuilderGoogleSearchConsole4RowReader this$0;
            {
                OlapBuilderGoogleSearchConsole4RowReader olapBuilderGoogleSearchConsole4RowReader = this$0;
                Objects.requireNonNull(olapBuilderGoogleSearchConsole4RowReader);
                this.this$0 = olapBuilderGoogleSearchConsole4RowReader;
            }

            @Nullable
            protected Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
                String name = columnDef.getName();
                if (name == null) {
                    return null;
                }
                Integer metricIdx = this.this$0.colMapper.get(columnDef);
                if (metricIdx != null) {
                    List keys = row.getKeys();
                    String dimValue = (String)CdCollections.getSafe((List)keys, (int)metricIdx, null);
                    if (dimValue != null && name.endsWith("date")) {
                        return 1.safeParseDate(dimValue);
                    }
                    return dimValue;
                }
                if (name.equals("M-CLICKS")) {
                    return row.getClicks();
                }
                if (name.equals("M-POSITIONS")) {
                    return row.getPosition();
                }
                if (name.equals("M-IMPRESSIONS")) {
                    return row.getImpressions();
                }
                if (name.equals("M-CTR")) {
                    return row.getCtr();
                }
                return null;
            }

            private static Comparable<? extends Comparable<?>> safeParseDate(String dimValue) {
                try {
                    return LocalDate.parse((String)dimValue);
                }
                catch (Exception ex) {
                    return dimValue;
                }
            }
        };
    }

    static {
        formatters.put("yyyyMMdd".length(), DateTimeFormat.forPattern((String)"yyyyMMdd"));
        formatters.put("yyyyMMddHH".length(), DateTimeFormat.forPattern((String)"yyyyMMddHH"));
        formatters.put("yyyyMMddHHmm".length(), DateTimeFormat.forPattern((String)"yyyyMMddHHmm"));
    }
}

