/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.ga4.datasource;

import com.google.analytics.data.v1beta.DimensionHeader;
import com.google.analytics.data.v1beta.DimensionValue;
import com.google.analytics.data.v1beta.MetricHeader;
import com.google.analytics.data.v1beta.MetricValue;
import com.google.analytics.data.v1beta.Row;
import com.google.analytics.data.v1beta.RunReportRequest;
import com.google.analytics.data.v1beta.RunReportResponse;
import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.googleapi.OlapBuilderGoogleCommon;
import crazydev.iccube.builder.googleapi.ga4.datasource.OlapBuilderGoogleAnalytics4Connection;
import crazydev.iccube.builder.googleapi.ga4.datasource.OlapBuilderGoogleAnalytics4DataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.OlapBuilderAbstractTableRow;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class OlapBuilderGoogleAnalytics4RowReader
extends OlapBuilderAbstractTableRowReader<OlapBuilderGoogleAnalytics4DataTable, OlapBuilderGoogleAnalytics4Connection> {
    private static final Map<Integer, DateTimeFormatter> formatters = new HashMap<Integer, DateTimeFormatter>();
    private final int pageSize;
    private List<Row> rows;
    private int offset = 0;
    private Map<String, Integer> colMapper = new HashMap<String, Integer>();
    private int i = -1;
    private LocalDate endLoadTime;

    protected OlapBuilderGoogleAnalytics4RowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderGoogleAnalytics4DataTable olapBuilderGoogleAnalytics4DataTable) {
        super(context, connectionPool, maxRowCount, (IOlapBuilderDataTableDef)olapBuilderGoogleAnalytics4DataTable, "Google Analytics V4 Data Table");
        this.pageSize = ((OlapBuilderGoogleAnalytics4DataTable)this.table).getTypedDS().getPageSize();
    }

    public void doInit() {
        this.initConnection();
        this.endLoadTime = null;
        this.offset = 0;
        this.colMapper.clear();
        this.loadPage();
    }

    public void done() {
        super.done();
    }

    public boolean isRowSafe() {
        return true;
    }

    private void loadPage() {
        RunReportRequest request = ((OlapBuilderGoogleAnalytics4DataTable)this.table).buildRequest(this.context, this.offset);
        if (request.getDateRangesCount() == 1) {
            String endDateS = request.getDateRanges(0).getEndDate();
            this.endLoadTime = OlapBuilderGoogleCommon.format.parseLocalDate(endDateS);
        }
        RunReportResponse response = ((OlapBuilderGoogleAnalytics4Connection)this.connection).getAnalyticsData(this.context.getRequestContext().asRuntimeContext()).runReport(request);
        this.rows = response.getRowsList();
        this.offset += this.rows.size();
        if (this.colMapper.isEmpty()) {
            List listD = response.getDimensionHeadersList();
            for (int i = 0; i < listD.size(); ++i) {
                this.colMapper.put("D-" + ((DimensionHeader)listD.get(i)).getName(), i);
            }
            List listM = response.getMetricHeadersList();
            for (int i = 0; i < listM.size(); ++i) {
                this.colMapper.put("M-" + ((MetricHeader)listM.get(i)).getName(), i);
            }
        }
        this.i = 0;
    }

    @Nullable
    public IOlapBuilderTableRow doNextRow() {
        if (this.i >= this.rows.size()) {
            if (this.rows.size() < this.pageSize) {
                return null;
            }
            this.loadPage();
        }
        if (this.i >= this.rows.size()) {
            return null;
        }
        final Row row = this.rows.get(this.i++);
        return new OlapBuilderAbstractTableRow(this){
            final /* synthetic */ OlapBuilderGoogleAnalytics4RowReader this$0;
            {
                OlapBuilderGoogleAnalytics4RowReader olapBuilderGoogleAnalytics4RowReader = this$0;
                Objects.requireNonNull(olapBuilderGoogleAnalytics4RowReader);
                this.this$0 = olapBuilderGoogleAnalytics4RowReader;
            }

            @Nullable
            protected Object getDataImpl(IOlapBuilderDataColumnDef columnDef) {
                if (columnDef.getName().equals("icEndLoadDate")) {
                    return this.this$0.endLoadTime;
                }
                String name = columnDef.getTableType();
                Integer index = this.this$0.colMapper.get(name);
                if (index == null || name == null) {
                    return null;
                }
                if (name.startsWith("D-")) {
                    DimensionValue val = row.getDimensionValues(index.intValue());
                    return this.toTyped(columnDef.getType(), val.getValue());
                }
                if (name.startsWith("M-")) {
                    MetricValue val = row.getMetricValues(index.intValue());
                    return val.getValue();
                }
                return null;
            }

            private Comparable toTyped(OlapBuilderInputType type, String value) {
                switch (type) {
                    case DATE: {
                        try {
                            DateTimeFormatter format = formatters.get(value.length());
                            return format == null ? value : format.parseLocalDate(value);
                        }
                        catch (Exception ex) {
                            return value;
                        }
                    }
                    case DATETIME: {
                        try {
                            DateTimeFormatter format = formatters.get(value.length());
                            return format == null ? value : format.parseLocalDateTime(value);
                        }
                        catch (Exception ex) {
                            return value;
                        }
                    }
                }
                return value;
            }
        };
    }

    static {
        formatters.put("yyyyMMdd".length(), DateTimeFormat.forPattern((String)"yyyyMMdd"));
        formatters.put("yyyyMMddHH".length(), DateTimeFormat.forPattern((String)"yyyyMMddHH"));
        formatters.put("yyyyMMddHHmm".length(), DateTimeFormat.forPattern((String)"yyyyMMddHHmm"));
    }
}

