/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.builder.googleapi.drive.datasource;

import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import crazydev.common.collection.CdFilter;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.excel.datasource.OlapBuilderExcelConnection;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleDriveConnection;
import crazydev.iccube.builder.googleapi.drive.datasource.OlapBuilderGoogleSpreadsheetDataSource;
import crazydev.iccube.builder.googleapi.errors.OlapGoogleApiError;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class OlapBuilderGoogleSpreadsheetConnection
extends OlapBuilderGoogleDriveConnection<OlapBuilderGoogleSpreadsheetDataSource> {
    public static final String EXCEL_MIME_TYPE = "application/vnd.ms-excel";
    private final boolean reuse;
    private String fileId;
    private String fileName;
    private OlapBuilderExcelConnection excelConn;

    public OlapBuilderGoogleSpreadsheetConnection(OlapBuilderGoogleSpreadsheetDataSource dataSource, boolean reuse) {
        super(dataSource);
        this.reuse = reuse;
        this.fileId = dataSource.getFileId();
        this.fileName = dataSource.getFileName();
    }

    @Override
    public void onOpen(OlapRuntimeContext context) throws OlapBuilderErrorException {
        super.onOpen(context);
        try {
            InputStream content;
            File file = this.getFile((Drive)this.jsonClient, this.fileId, this.fileName);
            if (file.getMimeType().equals(EXCEL_MIME_TYPE)) {
                Drive.Files.Get exportReq = ((Drive)this.jsonClient).files().get(file.getId());
                content = exportReq.executeMediaAsInputStream();
            } else {
                Drive.Files.Export exportReq = ((Drive)this.jsonClient).files().export(file.getId(), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                content = exportReq.executeMediaAsInputStream();
            }
            this.excelConn = OlapBuilderExcelConnection.openFromInputStream((InputStream)content, (String)("gdrive:" + this.fileId), (boolean)((OlapBuilderGoogleSpreadsheetDataSource)this.dataSource).isWithoutFormulas());
        }
        catch (GoogleJsonResponseException ex) {
            throw OlapGoogleApiError.error("Table", this.fileName, ex);
        }
        catch (TokenResponseException ex) {
            throw OlapGoogleApiError.error("Table", this.fileName, ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    protected void onClose() {
        super.onClose();
        if (this.reuse) {
            this.forceIsOpen();
        } else {
            if (this.excelConn != null) {
                this.excelConn.close();
            }
            this.excelConn = null;
        }
    }

    public OlapBuilderExcelConnection getExcelConn() {
        return this.excelConn;
    }

    public List<String> getSheetNames(CdFilter<String> filter) {
        return this.excelConn.getSheetNames(filter);
    }

    @Override
    protected String getMimeQ() {
        return " and (mimeType = 'application/vnd.ms-excel' OR mimeType contains 'spreadsheet')";
    }
}

